(function(){
    angular.module("app.manage")
        .controller("channelCtrl",["$rootScope","$scope","HttpService","ToolService","UtilService","$state","$stateParams","$timeout","$location",channelCtrl])
        .controller("channelDetailCtrl",["$scope","$rootScope","HttpService","ToolService","UtilService","$q","$state","$stateParams",channelDetailCtrl])
        .controller("channelAddCtrl",["$rootScope","$scope","HttpService","ToolService","UtilService","$q","$state","$stateParams",channelAddCtrl])
        .controller("channelSmCtrl",["$rootScope","$scope","HttpService","ToolService","UtilService","$q","$state","$stateParams","DateService","$timeout",channelSmCtrl])
        .controller("channelAdwordsCtrl",["$rootScope","$scope","HttpService","ToolService","UtilService","$q","$state","$stateParams","DateService","$timeout",channelAdwordsCtrl]);

    function channelCtrl($rootScope,$scope,HttpService,ToolService,UtilService,$state,$stateParams,$timeout,$location){
        if($rootScope.isSuper || $rootScope.isManage){
            $rootScope.editPower = true;
        }else{
            $rootScope.editPower = false;
        }
        var judgeBacklist = function(){
            if($rootScope.isSuper || $rootScope.isManage){
                if($rootScope.limitInfo.abTest.blacklist == true){
                    $scope.hasBlacklist = true;
                }else{
                    $scope.hasBlacklist = false;
                }
            }else{
                $scope.hasBlacklist = false;
            }
        }
        if(angular.isDefined($rootScope.limitInfo)){
            judgeBacklist();
        }
        else{
            $timeout(judgeBacklist,100);
        }

        var type = $stateParams.aid;
        if(!UtilService.isNullStr(type) && type != 'adwords' && type != 'smsearch' && type != 'gdt'){
            $scope.channType = type;
        }
        else{
            $scope.channType = 'ry_coop';
        }
        $scope.pageFlag = 1;//2渠道账号列表 3新建渠道账号

        $scope.filterTypeList = function(type){
            $scope.channType = type;
            $rootScope.channeluniqueName = 'normal';
            $rootScope.thirdtab = {'ry_coop':'常规渠道','custom':'自定义渠道','ry_bd':'SEM渠道'}[type];
            $scope.query();
        }

        $scope.deviceList = [
            {id:1,name:"已启用"},
            {id:2,name:"已停用"}
        ];
        $scope.deviceInit = $scope.deviceList[0].id;
        $scope.$on("deviceId",function(e,msg){
            $scope.seeFlag = msg.info.id;

            if($scope.customList && $scope.channType == 'custom'){
                $scope.filterList();
            }
        });

        $scope.query = function(bol){
            var url = '';
            if($scope.channType == 'custom'){
                url = "mng/channel/find";
                if($scope.customList && !bol){
                    $scope.filterList();
                    return;
                }
            }
            else{
                url = "mng/channel/find/unown";
                if($scope.coopList && !bol){
                    $scope.filterList();
                    return;
                }
            }
            var channelPM = HttpService.getInfo(url);
            ToolService.showLoading();
            channelPM.then(function(data){
                ToolService.hideLoading();
                if($scope.channType == 'custom'){
                    $scope.customList = data;
                    $scope.filterList();
                }
                else{
                    $scope.coopList = data;
                    if($scope.channelType == 'ry_coop'){
                        $scope.channelList = $scope.coopList.filter(function(item){
                            return item.type == 'ry_bd';
                        });
                    }else{
                        $scope.channelList = $scope.coopList.filter(function(item){
                            return item.type == 'ry_coop';
                        });
                    }
                }
                $scope.filterList();
                //$scope.channelList = data;
            });
        }
        $scope.filterList = function(){
            if($scope.channType == 'custom'){
                $scope.channelList = $scope.customList.filter(function(item){
                    if($scope.seeFlag == 1){return item.delFlag != true;}
                    if($scope.seeFlag == 2){return item.delFlag == true;}
                });
            }
            else{
                $scope.channelList = $scope.coopList.filter(function(item){
                    if($scope.channType == "ry_bd"){
                        return item.type == $scope.channType;
                    }else{
                        return item.type == $scope.channType && item.category == 'ADVERTISING';
                    }

                });
            }
        }
        $scope.query();

        var curfilpPage = null,rmd = new Date().getTime();
        $scope.$on('flipinfo',function(e,msg){
            if(msg.listkey == 'account'){
                $scope.flipPage2 = msg;
            }else if(msg.listkey == 'public'){
                $scope.flipPage = msg;
                $scope.flipChange = ++ rmd;
            }else{
                $scope.flipPage3 = msg;
            }
        });

        $scope.doRemove = function(info){
            $scope.delId = info.id;
            $scope.delInfo = info;
            ToolService.showLoading();
            var prePM = HttpService.getInfo("mng/channel/delete/valid/"+$scope.delId);
            prePM.then(function(data){
                ToolService.hideLoading();
                if(angular.isNumber(data) && data > 0){
                    $scope.delflagStatus = 2;
                    $scope.campnum = data;
                }
                else{
                    $scope.delflagStatus = 1;
                }
                $scope.delstatus = true;
            });
        }

        $scope.removeInfo = function(){
            if($scope.delflagStatus == 2){
                $scope.delstatus = false;
                return false;
            }
            var removePM = HttpService.deleteInfo("mng/channel/delete/"+$scope.delId);
            ToolService.showLoading();
            $scope.delstatus = 0;
            removePM.then(function(data){
                ToolService.hideLoading();

                ToolService.showTips("停用成功")
                $rootScope.operSubmitData("停用");
                $scope.query(true);
            });
        }
        $scope.enableInfo = function(info){
            var enablePM = HttpService.putInfo("mng/channel/enable/"+info.id);
            ToolService.showLoading();
            enablePM.then(function(data){
                ToolService.hideLoading();
                ToolService.showTips("启用成功")
                $scope.query(true);
                $rootScope.operSubmitData("启用");
            });
        }

        $scope.gopage = function(info){
            if(angular.isDefined(info)){
                $state.go("collect.channelDetail",{aid:info});
            }else{
                $state.go("collect.channelDetail");
            }
        }

        $scope.goGdt = function(info,flag){
            if(angular.isDefined(info)){
                info.step = flag;
                $state.go("collect.channelAdd",{aid:info});
            }else{
                $state.go("collect.channelAdd");
            }
        }

        $scope.goSm = function(info){
            if(angular.isDefined(info)){
                $state.go("collect.channelSm",{aid:info});
            }else{
                $state.go("collect.channelSm");
            }
        }

        $scope.goAdwords = function(info,flag){
            if(angular.isDefined(info)){
                info.step = flag;
                $state.go("collect.channelAdwords",{aid:info});
            }else{
                $state.go("collect.channelAdwords");
            }
        }

        $scope.goSub = function(info,flag){
            $scope.curChannel = info;
            if($scope.curChannel.name == 'adwords'){
                $scope.curChannel.nodeUrl = "http://doc.trackingio.com/qu-dao-pei-zhi-shuo-ming/adwords.html";
            }
            if(flag){
                $scope.pageFlag = 3;
            }else{
                $scope.backFlag(2);
            }

        }
        $scope.backFlag = function(flag){
            $scope.pageFlag = flag;
            if(flag == 2){
                if($scope.curChannel == undefined){
                    var subPM = HttpService.getInfo("mng/channelaccount/find/"+$scope.twoListID);
                }else{
                    var subPM = HttpService.getInfo("mng/channelaccount/find/"+$scope.curChannel.id);
                }
                ToolService.showLoading();
                subPM.then(function(data){
                    ToolService.hideLoading();
                    $scope.accountList = data;
                });
            }
            if(flag == 1){
                $scope.filterTypeList($scope.channType);
            }
        }

        if(($rootScope.channeluniqueName != "normal" && $rootScope.channeluniqueName != undefined && window.location.href.indexOf('channel')>-1) || type == 'adwords' || type == 'gdt' || type == 'smsearch'){
            if(type == 'adwords' || type == 'gdt' || type == 'smsearch'){
                $rootScope.channeluniqueName = type;
            }
            $scope.$watch("appid",function(n){
                if(angular.isDefined(n)){
                    var gdtPM = HttpService.getInfo($scope.appid+"/channel/find/"+$rootScope.channeluniqueName);
                    gdtPM.then(function(data){
                        ToolService.hideLoading();
                        $scope.gdtData = data;
                        $scope.gdtDataId = data.id;
                        $scope.gdtName = data.name;
                        $scope.gdtUrl = data.nodeUrl;
                        if($rootScope.channeluniqueName == 'adwords'){
                            $scope.gdtUrl = "http://doc.trackingio.com/qu-dao-pei-zhi-shuo-ming/adwords.html";
                        }
                    });
                }
            });
            $scope.$watch("gdtDataId",function(n){
                if(angular.isDefined(n)){
                    $scope.pageFlag = 2;
                    var subPM = HttpService.getInfo("mng/channelaccount/find/"+$scope.gdtDataId);
                    ToolService.showLoading();
                    subPM.then(function(data){
                        ToolService.hideLoading();
                        $scope.accountList = data;
                    });
                }
            });
            //$rootScope.channeluniqueName = 'normal';
        }

        $scope.openUrl = function(url){
            if(url == "http://doc.trackingio.com/qu-dao-pei-zhi-shuo-ming/guang-dian-901a-lao-mo-shi.html"){
                url = "http://doc.trackingio.com/qu-dao-pei-zhi-shuo-ming/guang-dian-tong.html";
            }
            window.open(url);
        }

        $scope.isdetail = false;
        $scope.showDetails = function(info){
            $scope.showDetailsInfo = info;
            $scope.channelAlias = info.alias;
            var listPM = null;
            listPM = HttpService.getInfo("mng/channelaccount/app/find/"+info.id);
            listPM.then(function(data){
                $scope.detailInfo = data;
            });
            ToolService.showAlp();
            $scope.isdetail = true;
            angular.element(document).on("click",function(){
                $scope.$apply(function(){
                    $scope.hideDetails();
                });
            });
        }
        $scope.hideDetails = function(){
            ToolService.hideAlp();
            $scope.isdetail = false;
        }

        $scope.changeAccoutStatus = function(info,flag){
            var url = "",txt = "";
            if(flag == 1){
                url = "mng/channelaccount/forbidden/"+info.id;
                txt = "停用成功";
            }
            else{
                url = "mng/channelaccount/enable/"+info.id;
                txt = "启用成功";
            }

            var enablePM = HttpService.putInfo(url);
            ToolService.showLoading();
            enablePM.then(function(data){
                $scope.twoListID = data.channel;
                ToolService.hideLoading();
                ToolService.showTips(txt)
                $scope.backFlag(2);
            });
        }
        /*var oldname = "";
        $scope.subDetail = {};
        $scope.goSubDetail = function(info){
            $scope.pageFlag = 3;
            $scope.tip = {};
            if(info){//编辑
                $scope.subDetail = info;
                $scope.channelname = info.name;
                $scope.channelpwd = info.password;
                $scope.channeluname = oldname = info.alias;
                $scope.channelRebate = info.rebate;
            }
            else{
                $scope.subDetail = {};
                $scope.channelname = "";
                $scope.channelpwd = "";
                $scope.channeluname = oldname = "";
                $scope.channelRebate = "";
            }
        }*/
        //判断名称是否存在
        $scope.existName = function(flag){
            if($scope.judgeNameChange(oldname,$scope.channeluname)){
                ToolService.showLoading();
                var namePM = HttpService.getInfo("mng/channelaccount/valid",{name:$scope.channeluname});
                namePM.then(function(data){
                    if(!$scope.tip){
                        $scope.tip = {};
                    }
                    ToolService.hideLoading();
                    if(data!=true){//存在
                        $scope.tip = {
                            channeluname:{
                                status:true,
                                txt:"渠道账号别名已存在"
                            }
                        }
                    }
                    else{
                        $scope.tip = {
                            channeluname:{
                                status:false
                            }
                        }
                        if(flag && flag == 1){
                            $scope.saveChannelUser();
                        }
                    }
                });
            }
            else{
                $scope.tip = {
                    channeluname:{
                        status:false
                    }
                }
                if(flag && flag == 1){
                    $scope.saveChannelUser();
                }
            }
        }
        $scope.saveChannelUser = function(){
            var par = {
                name: $scope.channelname,
                password: $scope.channelpwd,
                alias: $scope.channeluname,
                rebate:$scope.channelRebate,
                channel:$scope.curChannel.id
            };
            var verPar = {
                channelname: {
                    key: 'isNull',
                    val: $scope.channelname
                },
                channelpwd: {
                    key: 'isNull',
                    val: $scope.channelpwd
                },
                channeluname: {
                    key: 'username',
                    val: $scope.channeluname,
                    txt: '支持16位内汉字或32位内字母数字'
                }
            }

            $scope.tip = formJudge(verPar);
            if(!UtilService.isNullStr($scope.channelRebate)){
                if(!angular.isNumber($scope.channelRebate) || Number($scope.channelRebate) < 0 || Number($scope.channelRebate) > 100){
                    $scope.tip.succ = false;
                    $scope.tip.channelRebate = {
                        status: true,
                        txt : "填写数值过大或过小（取值范围[0.01-100]）"
                    }
                }
                else{
                    $scope.tip.channelRebate = {};
                }
            }else{
                $scope.tip.channelRebate = {};
            }

            if($scope.tip.succ != true) {
                ToolService.showTips($scope.formTipMsg);
                return false;
            }

            var savePM = null,txtTips = "添加成功";
            if($scope.subDetail.id!=null){
                par.id = $scope.subDetail.id;
                savePM = HttpService.putInfo("mng/channelaccount/update",par);
                txtTips = "修改成功";
            }else{
                savePM = HttpService.postInfo("mng/channelaccount/create",par);
            }
            ToolService.showLoading();
            savePM.then(function(data){
                ToolService.hideLoading();
                if(!data.id){
                    ToolService.showTips("账号或密码错误，请检查更新后重新创建");
                }
                else{
                    ToolService.showTips(txtTips);
                    $scope.backFlag(2);
                }
            });
        }




        $scope.dayList = [
            {id:999,name:"未设置"},
            {id:1,name:"1天"},
            {id:2,name:"2天"},
            {id:3,name:"3天"},
            {id:4,name:"4天"},
            {id:5,name:"5天"},
            {id:6,name:"6天"},
            {id:7,name:"7天"},
            {id:15,name:"15天"},
            {id:30,name:"30天"}
        ];
        $scope.dayList1 = [
            {id:1,name:"1天"},
            {id:2,name:"2天"},
            {id:3,name:"3天"},
            {id:4,name:"4天"},
            {id:5,name:"5天"},
            {id:6,name:"6天"},
            {id:7,name:"7天"},
            {id:15,name:"15天"},
            {id:30,name:"30天"}
        ];
        $scope.$on("ciDay",function(e,msg){
            $scope.ciDay = msg.info.id;
        });
        $scope.$on("ciDayOne",function(e,msg){
            $scope.ciDayOne = msg.info.id;
        });
        $scope.cheatList = [
            {id:999,name:"未设置"},
            {id:0,name:"严格"},
            {id:1,name:"普通"},
            {id:2,name:"宽松"}
        ];
        $scope.cheatList1 = [
            {id:0,name:"严格"},
            {id:1,name:"普通"},
            {id:2,name:"宽松"}
        ];
        $scope.$on("cheat",function(e,msg){
            $scope.cheat = msg.info.id;
        });
        $scope.$on("cheatOne",function(e,msg){
            $scope.cheatOne = msg.info.id;
        });
        //全渠道设置
        var rmd = new Date().getTime();
        $scope.allSet = function(){
            $scope.pageFlag = 3;
            var allPM = HttpService.getInfo("mng/channelparam/find/black");
            ToolService.showLoading();
            allPM.then(function(data){
                ToolService.hideLoading();
                $scope.allData = data.allChannelValidMatch;
                $scope.allBlack = data.allChannelBlackMatch;
                if($scope.allData == false){
                    $scope.ciDayInit = 999;
                }else{
                    $scope.ciDayInit = data.ciDay;
                }
                if($scope.allBlack ==false || data.blacklistLevel == -1){
                    $scope.cheatInit = 999;
                }else{
                    $scope.cheatInit = data.blacklistLevel;
                }

                $scope.blackType = data.blacklistStatus;
                $scope.datafresh2= ++rmd;
                $scope.datafresh1= ++rmd;
            });
        }
        $scope.saveAllSet = function(id,flag){
            //应用全渠道限制
            if($scope.ciDay == 999 && id == 0 && flag == "valid"){
                return false;
            }
            if($scope.cheat == 999 && id == 0 && flag == "black" && $scope.blackType){
                return false;
            }

            var isall = true;
            if(id == 1){
                var isdefault = true;
            }else{
                var isdefault = false;
            }
            var par = {};
            if($scope.ciDay == 999){
                par.blacklistStatus = $scope.blackType
            }
            if($scope.cheat == 999){
                par.ciDay = $scope.ciDay
            }
            if($scope.ciDay != 999 && $scope.cheat != 999){
                par.ciDay = $scope.ciDay;
                par.blacklistStatus = $scope.blackType;
            }

            if($scope.blackType == true){
                par.blacklistLevel = $scope.cheat;
            }else{
                par.blacklistLevel = -1;
            }
            var allsavePM = HttpService.putInfo("mng/channelparam/update/"+flag+"?isall="+isall+"&isdefault="+isdefault,par);
            ToolService.showLoading();
            allsavePM.then(function(data){
                ToolService.hideLoading();
                if(data == 'success'){
                    ToolService.showTips("保存成功");
                }
                if(flag == 'black'){
                    $scope.allBlack = true;
                }else{
                    $scope.allData = true;
                }
                if(id == 1){
                    $scope.allSet();
                }
            });
        }

        //渠道单独设置
        var oneSetId = 0;
        $scope.oneSet = function(info){
            $scope.pageFlag = 4;
            $scope.channelParam = info;

            var onePM = HttpService.getInfo("mng/channelparam/find/"+info.id);
            ToolService.showLoading();
            onePM.then(function(data){
                ToolService.hideLoading();
                oneSetId = data.id;
                $scope.winciDayOne = $scope.ciDayOneInit = data.ciDay;
                $scope.blackOneType = data.blacklistStatus;
                $scope.cheatOne = $scope.wincheatOne = $scope.cheatOneInit = data.blacklistLevel;
                /*if(data.blacklistLevel == -1){
                    $scope.cheatOne = $scope.cheatOneInit = 1;
                }  */
            });
        }

        $scope.blackClick = function(id){
            if(id == 1){
                $scope.blackOneType = true;
                if($scope.wincheatOne = -1){
                    $scope.cheatOne = $scope.wincheatOne = $scope.cheatOneInit = 1;
                }
            }else{
                $scope.blackOneType = false;
            }
        }

        $scope.saveOne = function(id,flag){
            var isall = false;
            if(id == 1){
                var isdefault = true;
            }else{
                var isdefault = false;
            }

            var par = {
                id: oneSetId,
                cid: $scope.channelParam.id,
                ciDay: $scope.ciDayOne,
                blacklistStatus:$scope.blackOneType
            };
            if($scope.blackOneType == true){
                par.blacklistLevel = $scope.cheatOne;
            }else{
                par.blacklistLevel = -1;
            }
            var onesavePM = HttpService.putInfo("mng/channelparam/update/"+flag+"?isall="+isall+"&isdefault="+isdefault,par);
            ToolService.showLoading();
            onesavePM.then(function(data){
                ToolService.hideLoading();
                $scope.closeWin();
                ToolService.showTips("保存成功");
                oneSetId = data.id;
                $scope.winciDayOne = $scope.ciDayOneInit = data.ciDay;
                $scope.blackOneType = data.blacklistStatus;
                $scope.cheatOne = $scope.wincheatOne = $scope.cheatOneInit = data.blacklistLevel;
            });
        }

        //数据有效期设置
        $scope.setData = function(){
            ToolService.showAlp();
            $scope.winFlag = 2;
        }
        //黑名单设置
        $scope.setBlock = function(){
            ToolService.showAlp();
            $scope.winFlag = 3;
        }

        //公共IP列表
        $scope.publicIP = function(){
            $scope.pageFlag = 5;
            var publicPM = HttpService.getInfo("mng/channelparam/find");
            ToolService.showLoading();
            publicPM.then(function(data){
                ToolService.hideLoading();
                $scope.campaignList = data;
                $scope.selectIDS = [];
                $scope.searchtxt = "";
            });
        }
        //公共IP操作
        $scope.saveIP = function(){
            var par = {
                ip: $scope.ip
            };
            var verPar = {
                ip: {
                    key: 'ipError',
                    val: $scope.ip
                }
            };
            $scope.tip = formJudge(verPar);
            if ($scope.tip.succ != true) {
                ToolService.showTips($scope.formTipMsg);
                return false;
            }
            if($scope.ip == oldIP){
                $scope.closeWin();
                return false;
            }
            var savePM = null,txtTips = "添加成功";
            if($scope.ipListId!=null){
                par.id = $scope.ipListId;
                savePM = HttpService.putInfo("mng/channelparam/update",par);
                txtTips = "修改成功";
            }else{
                savePM = HttpService.postInfo("mng/channelparam/create",par);
            }
            ToolService.showLoading();
            savePM.then(function(data){
                ToolService.hideLoading();
                if(data.code == -7000){
                    $scope.tip = {
                        ip:{
                            status:true,
                            txt:"IP地址已存在"
                        }
                    };
                }else{
                    ToolService.showTips(txtTips);
                    $scope.closeWin();
                    $scope.publicIP();
                }
            },function(data){
                ToolService.hideLoading();
                if(data.code == -7000){
                    $scope.tip = {
                        ip:{
                            status:true,
                            txt:"IP地址已存在"
                        }
                    };
                }
            });

        }

        $scope.$watch("flipChange+campaignList",function(){
            if($scope.flipPage && $scope.campaignList){
                curfilpPage = {start:$scope.flipPage.start+1,end:$scope.flipPage.end};
                if(curfilpPage.end > $scope.campaignList.length){
                    curfilpPage.end = $scope.campaignList.length;
                }
            }
        });
        //新增或编辑IP
        var oldIP = "";
        $scope.createIP = function(info){
            if(info == undefined){
                $scope.ip = "";
                $scope.ipListId = null;
            }else{
                $scope.ipListId = info.id;
                $scope.ip = info.ip;
                oldIP = info.ip;
            }
            ToolService.showAlp();
            $scope.winFlag=1;
            $scope.tip = {
                ip:{
                    status:false,
                    txt:""
                }
            };
        }
        $scope.closeWin = function(){
            ToolService.hideAlp();
            $scope.winFlag=0;
        }

        $scope.clickCkx = function(id){
            var idx = $scope.selectIDS.indexOf(id);
            if(idx > -1){
                $scope.selectIDS.splice(idx,1);
            }else{
                $scope.selectIDS.push(id);
            }
        }
        $scope.setCurrentList = function(){
            var curList = $scope.campaignList;
            if(!UtilService.isNullStr($scope.searchTxt)){
                var myFilterList = $scope.campaignList.filter(function(item){
                    if((item.name && angular.uppercase(String(item.name)).indexOf(angular.uppercase($scope.searchTxt))>-1) || (item.trackurl && angular.uppercase(String(item.trackurl)).indexOf(angular.uppercase($scope.searchTxt))>-1)){
                        return true;
                    }
                    else{
                        return false;
                    }
                });
                curList = myFilterList;
            }
            $scope.curShowList = curList;
        }
        $scope.curPageAll = function(){
            if(!$scope.flipPage || !$scope.campaignList){return false;}

            $scope.setCurrentList();
            curfilpPage.end = $scope.curShowList.length>curfilpPage.end ? curfilpPage.end:$scope.curShowList.length;
            var len = curfilpPage.end - curfilpPage.start,count = 0;

            for(var i = curfilpPage.start;i<curfilpPage.end;i++){
                var temp = $scope.curShowList[i];

                if($scope.selectIDS.indexOf(temp.id)>-1){
                    count ++;
                }
            }
            $scope.onePageCount = count;
            return len == count && len>0;
        }
        $scope.checkAllCurrent = function(){
            var bol = $scope.curPageAll();
            curfilpPage.end = $scope.curShowList.length>curfilpPage.end ? curfilpPage.end:$scope.curShowList.length;
            for(var i = curfilpPage.start;i<curfilpPage.end;i++){
                var temp = $scope.curShowList[i],idx = $scope.selectIDS.indexOf(temp.id);
                if(bol && idx>-1){
                    $scope.selectIDS.splice(idx,1);
                }
                if(!bol && idx==-1){
                    $scope.selectIDS.push(temp.id);
                }
            }
        }

        $scope.checkAllPage = function(){
            $scope.selectIDS = [];
            var len = $scope.curShowList.length,count = 0;
            for(var i = 0;i<len;i++){
                $scope.selectIDS.push($scope.curShowList[i].id);
            }
        }

        $scope.NocheckAllPage = function(){
            $scope.selectIDS = [];
        }

        $scope.$watch("searchTxt",function(n){
            if(angular.isDefined(n)){
                $scope.selectIDS = [];
            }
        });
        $scope.$watch("selectIDS",function(n){
            if($scope.selectIDS && $scope.selectIDS.length>0){
                $scope.iptHolder = "搜索后，所选内容将清除";
            }
            else{
                $scope.iptHolder = "输入名称或短链搜索";
            }
        });

        $scope.doBatchRemove = function(){
            $scope.delIPbatch = true;
        }

        $scope.removeBatchIP = function(){
            $scope.delIPbatch = false;
            var removePM = HttpService.deleteInfo("mng/channelparam/delete/"+$scope.selectIDS.join(","));
            ToolService.showLoading();
            removePM.then(function(data){
                ToolService.hideLoading();
                ToolService.showTips("删除成功");
                $scope.publicIP();
            });
        }

        $scope.doRemoveIP = function(info){
            $scope.delIPTips = "是否删除 “"+info.ip+"” 这个IP地址?";
            $scope.delIPstatus = true;
            $scope.delIPId = info.id;
        }
        $scope.removeInfoIP = function(){
            var removePM = HttpService.deleteInfo("mng/channelparam/delete/"+$scope.delIPId);
            ToolService.showLoading();
            removePM.then(function(data){
                ToolService.hideLoading();
                $scope.delIPstatus = false;
                ToolService.showTips("删除成功");
                $scope.publicIP();
            });
        }
    }

    function channelDetailCtrl($scope,$rootScope,HttpService,ToolService,UtilService,$q,$state,$stateParams){
        var editInfo = $stateParams.aid,infoId = null;
        if(angular.isDefined(editInfo) && editInfo!=null){
            infoId = $scope.id = editInfo.id;
        }

        var channelPM = HttpService.getInfo("1/channel/findcoop");
        channelPM.then(function(data){
            $scope.channelList = data;
        });

        var inName = "";
        $scope.init = function(){
            if(angular.isDefined(editInfo) && editInfo!=null){
                $scope.name = inName = editInfo.name;
                $scope.category = editInfo.category;
                $scope.url = editInfo.url;

                $scope.osIos = editInfo.osIos;
                $scope.osAndroid = editInfo.osAndroid;
                $scope.osWeb = editInfo.osWeb;

                if(editInfo.osIos){
                    $scope.os1 = 0;
                }
                if(editInfo.osAndroid){
                    $scope.os2 = 1;
                }
                if(editInfo.osWeb){
                    $scope.os3 = 2;
                }
            }else{
                $scope.osIos = false;
                $scope.osAndroid = false;
                $scope.osWeb = false;
                $scope.category='ADVERTISING';
                $scope.os = 0;
                inName = "";
            }
        };
        $scope.tipStatus = false;
        $scope.changeName = function(){
            if(angular.isDefined(editInfo) && editInfo!=null){

            }else{
                var isCheck = !$scope.osIos && !$scope.osAndroid && !$scope.osWeb;
                if(isCheck){
                    $("#name").blur();
                    ToolService.showTips("请先选择平台");
                }
            }
        }
        //监控渠道类型
        $scope.$watch("category",function(n){
            if(angular.isDefined(n)){
                $scope.osIos = false;
                $scope.osAndroid = false;
                $scope.osWeb = false;
            }
        });
        $scope.filterName = function(){
            if(!$scope.name){return false;}

            if($scope.name!=inName){
                $scope.filterChannels = $scope.channelList.filter(function(item){
                    var result = (item.name.indexOf($scope.name)>-1 || $scope.name.indexOf(item.name)>-1) && item.category == $scope.category;
                    if(!result){return false;}

                    if($scope.osIos){
                        result = result && item.osIos;
                    }
                    if($scope.osAndroid){
                        result = result && item.osAndroid;
                    }
                    if($scope.osWeb){
                        result = result && item.osWeb;
                    }
                    return result;
                });
                $scope.tipStatus = false;
            }
            else{
                $scope.filterChannels = [];
            }
        }

        $scope.clearFilter = function(){
            $scope.filterChannels = [];
        }
        $scope.doTips = function(channel){
            $scope.coopchannel = channel;
            $scope.name = channel.name;
            $scope.tipStatus = true;
            $scope.filterChannels = [];
        }

        $scope.checkTypes = function(os){
            if(os==1){
                $scope.osIos = !$scope.osIos;
            }else if(os==2){
                $scope.osAndroid = !$scope.osAndroid;
            }else{
                $scope.osWeb = !$scope.osWeb;
            }
            if($scope.osIos || $scope.osAndroid || $scope.osWeb){
                $scope.typeTip = "";
            }
        }
        $scope.init();
        $scope.save = function(){
            var par = {
                name: $scope.name,
                category: $scope.category,
                url: $scope.url,
                // os:$scope.os,
                osIos:$scope.osIos,
                osAndroid:$scope.osAndroid,
                osWeb:$scope.osWeb,
            };
            var verPar = {
                name: {
                    key: 'spcname',
                    val: par.name
                }
            }
            $scope.tip = formJudge(verPar);
            var isCheck = !$scope.osIos && !$scope.osAndroid && !$scope.osWeb;
            if ($scope.tip.succ != true || (isCheck && !infoId)) {
                if(isCheck && !infoId){$scope.typeTip = "请至少选择一个平台";}
                ToolService.showTips($scope.formTipMsg);
                return false;
            }
            var savePM = null,txtTips = "添加成功";
            if(infoId!=null){
                par.id = infoId;
                savePM = HttpService.putInfo("mng/channel/update",par);
                txtTips = "修改成功";
            }else{
                savePM = HttpService.postInfo("mng/channel/create",par);
            }
            ToolService.showLoading();
            savePM.then(function(data){
                ToolService.hideLoading();
                ToolService.showTips(txtTips);
                $scope.cancel();
                if(!infoId){
                   $rootScope.operSubmitData("新建");
                }
            });
        }

        $scope.cancel = function(){
            $state.go("collect.channel",{aid:'custom'});
        }
    }


    function channelAddCtrl($rootScope,$scope,HttpService,ToolService,UtilService,$q,$state,$stateParams){
        if($rootScope.isSuper || $rootScope.isManage){
            $scope.editPower = true;
        }else{
            $scope.editPower = false;
        }

        $rootScope.channeluniqueName = 'gdt';
        $scope.stepflag = 1;    //1、2、3步
        $scope.step1 = 'normal';     //第一步   normal   failure  success
        var editInfo = $stateParams.aid;
        if(angular.isDefined(editInfo) && editInfo!=null){
            infoId = $scope.id = editInfo.id;
            if(editInfo.step == 3){
                $scope.stepflag = 3;
            }
        }
        var oldname = "";
        var oldthirdAccountCode = "";
        var oldalias = "";
        $scope.pastStatus = false;
        $scope.init = function(){
            if(angular.isDefined(editInfo) && editInfo!=null){
                $scope.state = oldname = editInfo.name;
                $scope.accountid = oldthirdAccountCode = editInfo.thirdAccountCode;
                $scope.rebate = parseFloat(editInfo.rebate);
                $scope.alias = oldalias = editInfo.alias;
                $scope.pastStatus = editInfo.pastStatus;
                $scope.step1='success';

            }
            else{
                $scope.rebate = 0;
            }
        };
        $scope.init();

        if($scope.id == undefined){
            $scope.flag = 1;
        }else{
            $scope.flag = 0;
        }

        $scope.cancel = function(){
            if($scope.empowerType == true){
                var savePM = null;
                savePM = HttpService.deleteInfo("mng/channelaccount/delete/authorize/"+$scope.flag+"/"+$scope.state);
                savePM.then(function(data){
                    $state.go("collect.channel",{aid:'ry_coop'});
                });
            }else{
                $state.go("collect.channel",{aid:'ry_coop'});
            }

        }

        $scope.nextStep = function(){
            $scope.stepflag = $scope.stepflag + 1;
        }
        $scope.lastStep = function(){
            $scope.stepflag = $scope.stepflag - 1;
        }
        //弹窗
        $scope.openDialog = function(){
            window.open("http://doc.trackingio.com/qu-dao-pei-zhi-shuo-ming/guang-dian-tong.html");
        }

        $scope.empower = function(){
            if($scope.checkID != true && $scope.checkQQ != true){
                var par = {
                    state: $scope.state,
                    accountid: $scope.accountid
                };
                var verPar = {
                    state: {
                        key: 'num',
                        val: par.state,
                        txt: '合法性为仅支持输入数字，长度不限'
                    },
                    accountid: {
                        key: 'num',
                        val: par.accountid,
                        txt: '合法性为仅支持输入数字，长度不限'
                    }
                }
                $scope.tip = formJudge(verPar);
                if ($scope.tip.succ != true) {
                    ToolService.showTips($scope.formTipMsg);
                    return false;
                }
                window.open("https://developers.e.qq.com/oauth/authorize?client_id=1106237187&redirect_uri=http://www.trackingio.com/api/mng/channelaccount/code&state="+$scope.state);
                $scope.empowerType = true;
            }
        }

        $scope.empowerError = function(){
            $scope.empowerType = false;
        }

        $scope.empowerOK = function(){
            var savePM = null;
            savePM = HttpService.getInfo("mng/channelaccount/valid/qq?qq="+$scope.state);
            savePM.then(function(data){
                $scope.empowerType = false;
                if(data == true){
                    $scope.step1 = 'success';
                }else{
                    $scope.step1 = 'failure';
                }
            });
        }

        $scope.powerAgain = function(){
            $scope.step1='normal';
        }

        $scope.exixtQQ = function(){
            if(oldname == $scope.state){
                $scope.checkQQ = false;
            }else{
                if($scope.state == "" || $scope.state == undefined){
                    return false;
                }
                var packPM = HttpService.getInfo("mng/channelaccount/valid/qq?qq="+$scope.state);
                packPM.then(function(data){
                    if(data.content == false){
                        $scope.checkQQ = false;
                        $scope.tip = {
                            state:{
                                status:false,
                                txt:''
                            }
                        };
                    }else{
                        $scope.checkQQ = true;
                        $scope.tip = {
                            state:{
                                status:true,
                                txt:'该渠道账号已被授权，如果需要对该账号重新授权，请到对应账号进行修改。'
                            }
                        };
                    }
                });
            }
        }

        $scope.exixtID = function(){
            if(oldthirdAccountCode == $scope.accountid){
                $scope.checkID = false;
            }else{
                if($scope.accountid == "" || $scope.accountid == undefined){
                    return false;
                }
                var packPM = HttpService.getInfo("mng/channelaccount/valid/accountid?accountid="+$scope.accountid);
                packPM.then(function(data){
                    if(data.content == false){
                        $scope.checkID = false;
                        $scope.tip = {
                            accountid:{
                                status:false,
                                txt:''
                            }
                        };
                    }else{
                        $scope.checkID = true;
                        $scope.tip = {
                            accountid:{
                                status:true,
                                txt:'该账号id已被绑定到其他渠道账号，请到对应账号进行修改'
                            }
                        };
                    }
                });
            }
        }

        $scope.saveOne = function(){
            var par = {
                name: $scope.state,
                thirdAccountCode: $scope.accountid
            };
            var savePM = null;
            savePM = HttpService.postInfo("mng/channelaccount/authorize",par);
            savePM.then(function(data){
                $scope.aliasID = data.id;
                $scope.stepflag = $scope.stepflag + 1;
            });
        }


        //第二步
        $scope.saveTwo = function(){
            if($scope.checkAlias == false){
                return false;
            }
            if($scope.aliasID == null || $scope.aliasID == undefined){
                $scope.aliasID = $scope.id
            }
            var parmas = {
                alias: $scope.alias,
                rebate: $scope.rebate,
                id: $scope.aliasID
            };
            var verParmas = {
                alias: {
                    key: 'isNull',
                    val: $scope.alias
                }
            }
            $scope.tip = formJudge(verParmas);
            if ($scope.tip.succ != true) {
                ToolService.showTips($scope.formTipMsg);
                return false;
            }
            var savePM = null;
            savePM = HttpService.putInfo("mng/channelaccount/alias",parmas);
            savePM.then(function(data){
                if(data.id != null){
                    $scope.createID = data.id;
                    $scope.stepflag = 3;
                    //$scope.tableList();
                }
            });
        }
        $scope.exixtAlias = function(){
            if(oldalias == $scope.alias){
                $scope.checkAlias = true;
            }else{
                if($scope.alias == "" || $scope.alias == undefined){
                    return false;
                }
                var packPM = HttpService.getInfo("mng/channelaccount/valid?name="+$scope.alias);
                packPM.then(function(data){
                    if(data == true){
                        $scope.checkAlias = true;
                        $scope.tip = {
                            alias:{
                                status:false,
                                txt:''
                            }
                        };
                    }else{
                        $scope.checkAlias = false;
                        $scope.tip = {
                            alias:{
                                status:true,
                                txt:'该渠道账号别名已经被占用'
                            }
                        };
                    }
                });
            }
        }

        //第三步
        var rmd = new Date().getTime();
        $scope.productList = function(){
            var savePM = null;
            if($scope.createID== null || $scope.createID == undefined){
                $scope.createID = $scope.id;
            }
            //savePM = HttpService.getInfo("mng/channelaccount/app/list?accountid="+$scope.accountid);
            savePM = HttpService.getInfo("mng/channelaccount/"+$scope.createID+"/app/list?linkuserid="+$scope.createID+"&unique_name=gdt");
            savePM.then(function(data){
                $scope.dayList = data;
                $scope.appnameInit = data[0].id;
                $scope.$on("appname",function(e,msg){
                    $scope.appname = msg.info.id;
                    $scope.appType = msg.info.platform;
                    $scope.appkey = msg.info.appkey;
                });
            });
            $scope.datafresh = ++rmd;
        }

        $scope.tableList = function(){
            var savePM = null;
            if($scope.createID == null || $scope.createID == undefined){
                $scope.createID = $scope.id;
            }
            savePM = HttpService.getInfo("mng/channelaccount/app/find/"+$scope.createID);
            savePM.then(function(data){
                $scope.tableData = data;
            });
        }

        $scope.$watch("stepflag",function(n){
            if(angular.isDefined(n)){
                if($scope.stepflag == 3){
                    $scope.tableList();
                }
            }
        });

        //监测appname
        $scope.$watch("appname",function(n){
            $scope.nodata();
        });

        $scope.nodata = function(){
            $scope.createType = 'noadd';
            $scope.thirdAppId = "";
            $scope.userActionSetId = "";
            $scope.tip = {
                thirdAppId:{
                    status:false
                }
            };
        }

        $scope.addType = false;
        $scope.addProduct = function(){
            if($scope.createType == "inadd" || $scope.createType == "erroradd" || $scope.createType == "openadd"){
                ToolService.showTips("请先完成当前产品测试，再添加下一个产品。");
            }else{
                $scope.userActionSetIdTxt = "点击右侧按钮获取行为数据源ID";
                $scope.createType = "openadd";
                $scope.addType = true;
                $scope.productList();
            }
        }
        $scope.closeProduct = function(){
            $scope.addType = false;
            $scope.nodata();
        }

        //获取行为数据源ID
        $scope.getDmpCode = function(){
            var par = {
                thirdAppId: $scope.thirdAppId,
                linkUserId: $scope.createID,
                appName: $scope.appname,
                appType: $scope.appType,
                accountId: $scope.accountid
            };
            var verPar = {
                thirdAppId: {
                    key: 'isNull',
                    val: par.thirdAppId
                }
            }
            $scope.tip = formJudge(verPar);
            if ($scope.tip.succ != true) {
                ToolService.showTips($scope.formTipMsg);
                return false;
            }
            var savePM = null;
            savePM = HttpService.postInfo("mng/channelaccount/userid/create",par);
            savePM.then(function(data){
                if(data.data != null || data.data != undefined){
                    $scope.userActionSetId = data.data;
                    $scope.userActionSetIdTxt = "";
                }else{
                    $scope.tip = {
                        thirdAppId:{
                            status:true,
                            txt:data.msg
                        }
                    };
                }
            });
        }

        //noadd未添加  openadd打开弹窗     inadd添加中    okadd添加成功    erroradd添加失败
        $scope.createType = "noadd";

        //连接测试
        $scope.testDmp = function(){
            var par = {
                thirdAppId: $scope.thirdAppId,
                appName: $scope.appname,
                appkey: $scope.appkey,
                userActionSetId: $scope.userActionSetId,
                linkUserId: $scope.createID,
                appType: $scope.appType,
                accountId: $scope.accountid
            };
            var verPar = {
                thirdAppId: {
                    key: 'isNull',
                    val: $scope.thirdAppId
                },
                userActionSetId: {
                    key: 'isNull',
                    val: $scope.userActionSetId
                }
            }
            $scope.tip = formJudge(verPar);
            if ($scope.tip.succ != true) {
                ToolService.showTips($scope.formTipMsg);
                return false;
            }
            var savePM = null;
            $scope.createType = "inadd";
            savePM = HttpService.postInfo("mng/channelaccount/app/create",par);
            savePM.then(function(data){
                if(data.code == 0){
                    $scope.createType = "okadd";
                    $scope.tableList();
                    $scope.closeProduct();
                }else{
                    $scope.createType = "erroradd";
                    $scope.failureText = data.message;
                }
            });
        }

        //删除
        $scope.deletePro = function(obj){
            $scope.delstatus = true;
            $scope.delId = obj.id;
        }
        $scope.removeInfo = function(){
            var removePM = HttpService.deleteInfo("mng/channelaccount/delete/app/"+$scope.delId);
            ToolService.showLoading();
            removePM.then(function(data){
                ToolService.hideLoading();
                $scope.delstatus = false;
                ToolService.showTips("删除成功");
                $scope.tableList();
            });
        }

        //保存
        $scope.save = function(){
            $state.go("collect.channel",{aid:'ry_coop'});
        }
    }

    function channelSmCtrl($rootScope,$scope,HttpService,ToolService,UtilService,$q,$state,$stateParams,DateService,$timeout){
        $rootScope.channeluniqueName = 'smsearch';
        var editInfo = $stateParams.aid;
        if(angular.isDefined(editInfo) && editInfo!=null){
            var infoId = $scope.id = editInfo.id;
        }

        var oldalias = "";
        $scope.init = function(){
            if(angular.isDefined(editInfo) && editInfo!=null){
                $scope.alias = oldalias = editInfo.alias;
                $scope.name = editInfo.name;
                $scope.password = editInfo.password;
                //pastStatus   false为授权成功
                if(editInfo.pastStatus == false){
                    $scope.step1 = 'success';
                }else{
                    $scope.step1 = 'failure';
                }
            }
        };
        $scope.init();

        var channelID = "";
        $scope.$watch("appid",function(n){
            if(angular.isDefined(n)){
                var gdtPM = HttpService.getInfo($scope.appid+"/channel/find/smsearch");
                gdtPM.then(function(data){
                    ToolService.hideLoading();
                    channelID = data.id;
                });
            }
        });

        $scope.cancel = function(){
            $state.go("collect.channel",{aid:'ry_bd'});
        }

        $scope.exixtName = function(){
            if(oldalias == $scope.alias){
                $scope.checkName = true;
            }else{
                if($scope.alias == "" || $scope.alias == undefined){
                    return false;
                }
                ToolService.showLoading();
                var packPM = HttpService.getInfo("mng/channelaccount/valid?name="+$scope.alias);
                packPM.then(function(data){
                    ToolService.hideLoading();
                    if(data == true){
                        $scope.checkName = true;
                        $scope.tip = {
                            alias:{
                                status:false,
                                txt:''
                            }
                        };
                    }else{
                        $scope.checkName = false;
                        $scope.tip = {
                            alias:{
                                status:true,
                                txt:'该账号别名已存在，请更换。'
                            }
                        };
                    }
                });
            }
        }
        $scope.empowerType = false;
        $scope.empower = function(){
            if($scope.checkName == false){
                return false;
            }
            var par = {
                channel: channelID,
                alias: $scope.alias,
                name: $scope.name,
                password: $scope.password
            };
            var verPar = {
                alias: {
                    key: 'isNull',
                    val: par.alias
                },
                name: {
                    key: 'isNull',
                    val: par.name
                },
                password: {
                    key: 'isNull',
                    val: par.password
                }
            }
            $scope.tip = formJudge(verPar);
            if ($scope.tip.succ != true) {
                return false;
            }
            ToolService.showLoading();
            var savePM = null;
            if($scope.id!=null){
                par.id = $scope.id;
                savePM = HttpService.putInfo("mng/channel/account/update",par);
            }else{
                savePM = HttpService.postInfo("mng/channel/account/create",par);
            }
            savePM.then(function(data){
                ToolService.hideLoading();
                $scope.empowerType = true;
                $scope.id = $scope.empowerID = data.id;
                window.open("https://e.sm.cn/auth/OAuth2/authorizationRequest?response_type=code&state="+$scope.empowerID+"&scope=1,2&redirect_uri=http://www.trackingio.com/api/third/getToken&client_id=434&client_secret=3e1bdcb210290c0668566e414373c8c3");
            });
        }
        $scope.failureAlert = false;
        $scope.empowerOK = function(){
            var savePM = null;
            savePM = HttpService.getInfo("mng/channel/account/checkstatus?id="+$scope.empowerID);
            savePM.then(function(data){
                $scope.empowerType = false;
                if(data == true){
                    $scope.step1 = 'success';
                    ToolService.showTips("授权成功");
                    $scope.cancel();
                }else{
                    $scope.step1 = 'failure';
                    $scope.failureAlert = true;
                }
            });
        }

        $scope.empowerError = function(){
            $scope.empowerType = false;
            $scope.pastStatus = true;
        }
    }

    function channelAdwordsCtrl($rootScope,$scope,HttpService,ToolService,UtilService,$q,$state,$stateParams,DateService,$timeout){
        if($rootScope.isSuper || $rootScope.isManage){
            $rootScope.editPower = true;
        }else{
            $rootScope.editPower = false;
        }
        $scope.stepflag = 1;

        $rootScope.channeluniqueName = 'adwords';
        var editInfo = $stateParams.aid;
        if(angular.isDefined(editInfo) && editInfo!=null){
            var infoId = $scope.id = editInfo.id;
            if(editInfo.step == 2){
                $scope.stepflag = 2;
            }
        }
        var oldname = "";
        var oldthirdAccountCode = "";
        var oldalias = "";
        $scope.pastStatus = false;
        $scope.init = function(){
            if(angular.isDefined(editInfo) && editInfo!=null){
                $scope.name = oldname = editInfo.name;
                $scope.thirdAccountCode = oldthirdAccountCode = editInfo.thirdAccountCode;
                $scope.alias = oldalias = editInfo.alias;
            }
        };
        $scope.init();

        $scope.cancel = function(){
            $state.go("collect.channel",{aid:'ry_coop'});
        }

        var channelID = "";
        $scope.$watch("appid",function(n){
            if(angular.isDefined(n)){
                var gdtPM = HttpService.getInfo($scope.appid+"/channel/find/adwords");
                gdtPM.then(function(data){
                    ToolService.hideLoading();
                    channelID = data.id;
                });
            }
        });

        //弹窗
        $scope.openDialog = function(){
            window.open("http://doc.trackingio.com/qu-dao-pei-zhi-shuo-ming/adwords.html");
        }

        $scope.saveOne = function(){
            //$scope.stepflag = 2;
            var par = {
                channel: channelID,
                alias: $scope.alias,
                name: $scope.name,
                thirdAccountCode: $scope.thirdAccountCode
            };
            var verPar = {
                alias: {
                    key: 'spcname',
                    max:40,
                    val: $scope.alias,
                    txt: "含非法字符或过长（支持输入汉字、大小写字母、数字、下划线、中划线，长度限制40字符以内）"
                },
                name: {
                    key: 'isNull',
                    val: $scope.name
                },
                thirdAccountCode: {
                    key: 'isNull',
                    val: $scope.thirdAccountCode
                }
            }
            $scope.tip = formJudge(verPar);
            if ($scope.tip.succ != true) {
                return false;
            }
            var savePM = null;
            if($scope.id!=null){
                par.id = $scope.id;
                savePM = HttpService.putInfo("mng/channel/account/update",par);
            }else{
                savePM = HttpService.postInfo("mng/channel/account/create",par);
            }
            savePM.then(function(data){
                ToolService.hideLoading();
                if(data.code == -5002){
                    $scope.tip = {
                        alias:{
                            status:true,
                            txt:data.message
                        }
                    };
                }else if(data.code == -5003){
                    $scope.tip = {
                        thirdAccountCode:{
                            status:true,
                            txt:data.message
                        }
                    };
                }else{
                    $scope.createID = $scope.aliasID = data.id;
                    $scope.stepflag = $scope.stepflag + 1;
                }
            });
        }

        $scope.lastStep = function(){
            $scope.stepflag = $scope.stepflag - 1;
        }


        var rmd = new Date().getTime();
        $scope.productList = function(){
            var savePM = null;
            if($scope.createID== null || $scope.createID == undefined){
                $scope.createID = $scope.id;
            }
            //应用列表
            savePM = HttpService.getInfo("mng/channelaccount/"+$scope.createID+"/app/list?linkuserid="+$scope.createID+"&unique_name=adwords");
            savePM.then(function(data){
                $scope.dayListALL = data;
                $scope.dayList = $scope.dayListALL.filter(function(item){
                    return item.platform == 'iOS';
                })
                $scope.appnameInit = $scope.dayList[0].id;
                $scope.$on("appname",function(e,msg){
                    $scope.appname = msg.info.id;
                    $scope.appType = msg.info.platform;
                    $scope.appkey = msg.info.appkey;
                });
            });
            $scope.datafresh = ++rmd;
        }

        //已保存产品列表
        $scope.tableList = function(){
            var savePM = null;
            if($scope.createID == null || $scope.createID == undefined){
                $scope.createID = $scope.id;
            }
            savePM = HttpService.getInfo("mng/channelaccount/app/find/"+$scope.createID);
            savePM.then(function(data){
                $scope.tableData = data;
            });
        }

        $scope.$watch("stepflag",function(n){
            if(angular.isDefined(n)){
                if($scope.stepflag == 2){
                    $scope.tableList();
                }
            }
        });

        //监测appname
        $scope.$watch("appname",function(n){
            $scope.nodata();
        });
        $scope.nodata = function(){
            $scope.createType = 'noadd';
            $scope.userActionSetId = "";
            $scope.tip = {
                userActionSetId:{
                    status:false,
                    txt:''
                }
            };
        }

        //添加和关闭
        $scope.addType = false;
        $scope.addProduct = function(){
            if($scope.createType == "inadd" || $scope.createType == "erroradd" || $scope.createType == "openadd"){
                ToolService.showTips("请先完成当前产品测试，再添加下一个产品。");
            }else{
                $scope.createType = "openadd";
                $scope.addType = true;
                $scope.productList();
            }
        }
        $scope.closeProduct = function(){
            $scope.addType = false;
            $scope.nodata();
        }

        //检测linkid
        $scope.checkLinkID = false;
        $scope.exixtLinkId = function(){
            var par = {
                linkUserId: $scope.createID,
                channel: channelID,
                fieldkey: 'linkid',
                fieldvalue: $scope.userActionSetId
            };
            var verPar = {
                fieldvalue: {
                    key: 'isNull',
                    val: par.fieldvalue
                }
            }
            $scope.tip = formJudge(verPar);
            if ($scope.tip.succ != true) {
                return false;
            }
            var packPM = HttpService.getInfo("mng/channelaccount/109/app/checkname",par);
            packPM.then(function(data){
                ToolService.hideLoading();
                if(data == true){
                    $scope.checkLinkID = true;
                    $scope.tip = {
                        userActionSetId:{
                            status:false,
                            txt:''
                        }
                    };
                }else{
                    $scope.checkLinkID = false;
                    $scope.tip = {
                        userActionSetId:{
                            status:true,
                            txt:'该LinkID已存在，请更换。'
                        }
                    };
                }
            });
        }

        //noadd未添加  openadd打开弹窗     inadd添加中    okadd添加成功    erroradd添加失败
        $scope.createType = "noadd";
        //连接测试
        $scope.testDmp = function(){
            if($scope.checkLinkID == false){
                return false;
            }
            var par = {
                appName: $scope.appname,
                appkey: $scope.appkey,
                userActionSetId: $scope.userActionSetId,
                linkUserId: $scope.createID,
                appType: $scope.appType
            };
            var verPar = {
                userActionSetId: {
                    key: 'isNull',
                    val: par.userActionSetId
                }
            }
            $scope.tip = formJudge(verPar);
            if ($scope.tip.succ != true) {
                ToolService.showTips($scope.formTipMsg);
                return false;
            }
            var savePM = null;
            $scope.createType = "inadd";
            savePM = HttpService.postInfo("mng/channelaccount/"+$scope.createID+"/app/create",par);
            savePM.then(function(data){
                if(data.id != undefined){
                    $scope.createType = "okadd";
                    $scope.checkLinkID = false;
                    $scope.tableList();
                    $scope.closeProduct();
                }else{
                    $scope.createType = "erroradd";
                    $scope.failureText = data.message;
                }
            });
        }

        //删除
        $scope.deletePro = function(obj){
            $scope.delstatus = true;
            $scope.delId = obj.id;
        }
        $scope.removeInfo = function(){
            var removePM = HttpService.deleteInfo("mng/channelaccount/delete/app/"+$scope.delId);
            ToolService.showLoading();
            removePM.then(function(data){
                ToolService.hideLoading();
                $scope.delstatus = false;
                ToolService.showTips("删除成功");
                $scope.tableList();
            });
        }

        //保存
        $scope.save = function(){
            $state.go("collect.channel",{aid:'ry_coop'});
        }

    }
})();
