(function(){
    angular.module("app.manage")
        .controller("profileCtrl",["$scope","HttpService","ToolService",profileCtrl]);

    function profileCtrl($scope,HttpService,ToolService){
    	$scope.query = function(){
    		var profilePM = HttpService.getInfo("mng/profile/"+$scope.appid+"/find");
            ToolService.showLoading();
            profilePM.then(function(data){
                ToolService.hideLoading();
                $scope.infoEditId = -1;
                $scope.profileList = data;
            });
    	}
    	$scope.$watch("appid",function(n){
    		if(angular.isDefined(n)){
    			$scope.query();
    		}
    	});
        
        $scope.doEdit = function(obj,id){
            $scope.infoEditId = id;
            obj.id = id;
            obj.editname = obj.attrAlias;
        }

        $scope.$on('flipinfo',function(e,msg){
            $scope.flipPage = msg;
        });

        //事件更新
        $scope.updateProfile = function(info){
            var params = {
                appkey:$scope.appkey,
                attr:info.attr,
                attrAlias:info.editname
            }
            var has = $scope.profileList.filter(function(item){
                return item.attrAlias == info.editname && item.id!=info.id;
            });
            if(has.length>0){
                ToolService.showTips("用户属性名称不能重复")
                return false;
            }

            var tips = formJudge({
                name:{
                    key:'spcname2',
                    val:params.attrAlias
                }
            });
            if(tips.succ != true){
                ToolService.showTips("仅支持包含下划线的40位以内字符");
                return false;
            }

            var updatePM = HttpService.putInfo("mng/profile/update",params);
            ToolService.showLoading();
            updatePM.then(function(data){
                ToolService.hideLoading();
                ToolService.showTips("修改成功")
                $scope.query();
            });
        }

        //启用停用
        $scope.onOff = function(info,flag){
        	var url = "mng/profile/enable/"+$scope.appkey+"/"+info.attr,tipmsg = "启用成功";
        	if(flag && flag==1){
        		url = "mng/profile/forbidden/"+$scope.appkey+"/"+info.attr;
                tipmsg = "停用成功";
        	}
        	var userPM = HttpService.putInfo(url);
            ToolService.showLoading();
	    	userPM.then(function(data){
                ToolService.hideLoading();
	    		ToolService.showTips(tipmsg)
                $scope.query();
	    	});
        }

        $scope.changeStatus = function(flag,attr){
            var method = "";
            switch (flag) {
                case 1:
                    method = "addCondition";
                    break;
                case 2:
                    method = "delCondition";
                    break;
                default:
                    break;
            }
            if(method!=''){
                var putPM = HttpService.putInfo("mng/profile/"+method+"/"+$scope.appid+"/"+attr);
                putPM.then(function(data){
                    if(!localStorage.getItem("joinFiltrate") && flag==1){
                        ToolService.showTips("操作成功,可以按属性名称在事件、漏斗或留存功能中查看或筛选",4000);
                        localStorage.setItem("joinFiltrate","joinFiltrate");
                    }else{
                        ToolService.showTips("操作成功");
                    }
                    $scope.query();
                });
            }
        }
    }
 
})();