(function(){
    angular.module("app.manage")
        .controller("userinfoCtrl",["$rootScope","$scope","HttpService","ToolService","UtilService","$state",userinfoCtrl])

    function userinfoCtrl($rootScope,$scope,HttpService,ToolService,UtilService,$state){
    	$scope.isDemo = ToolService.isDemoUser();
        $scope.queryInfo = function(){
            var userPM = HttpService.getInfo("account/detail",{});
            userPM.then(function(data){
                $scope.myid = data.id;
                $scope.email = data.email;
                $scope.name = data.name;
                $scope.company = data.company;
                $scope.phone = data.phone;
                $scope.qq = data.qq;
                $scope.createTime = data.createTime;
                $scope.wechat = data.wechat;
                $scope.logList = data.userLogList!=null ? data.userLogList : [];
            });
        }
        $scope.queryInfo();

        $scope.save = function(){
            var par = {
                name: $scope.name,
                company: $scope.company,
                phone: $scope.phone,
                wechat: $scope.wechat,
                qq: $scope.qq
            };
            var verPar = {
                name: {
                    key: 'username',
                    max:32,
                    val: par.name
                },
                company: {
                    key: 'companyname',
                    max:96,
                    val: par.company
                },
                phone: {
                    key: 'cellphone',
                    val: par.phone
                },
                wechat: {
                    key: 'wechat',
                    val: par.wechat
                },
                qq: {
                    key: 'qq',
                    val: par.qq
                }
            }
            $scope.tip = formJudge(verPar);
            if ($scope.tip.succ != true) { 
                ToolService.showTips($scope.formTipMsg);
                return false;
            }

            var savePM = HttpService.putInfo("account/updateBase",par);
            ToolService.showLoading();
            savePM.then(function(data){
                ToolService.hideLoading();
                if(data==1){
                    ToolService.showTips("修改成功");
                    $scope.toedit = false;
                }
                else{
                     ToolService.showTips("修改失败");
                }
                
            });
        }

        $scope.savepwd = function(){
            var par = {
                pwd: $scope.pwd,
                newpwd: $scope.newpwd
            };
            var verPar = {
                pwd: {
                    key: 'isNull',
                    val: par.pwd
                },
                newpwd: {
                    key: 'pwd',
                    val: par.newpwd
                },
                crmpwd: {
                    key: 'pwd',
                    val: $scope.crmpwd
                }
            }
            $scope.tip = formJudge(verPar);
            if($scope.pwd != undefined && $scope.pwd == $scope.newpwd){
                if ($scope.tip.succ == true) {
                    $scope.tip.succ = false;
                }
                $scope.tip.newpwd = {
                    status:true,
                    txt:"新旧密码一致，请重新修改密码"
                }    
            }
            if($scope.newpwd!= undefined && $scope.crmpwd!= undefined && $scope.newpwd!=$scope.crmpwd){
                if ($scope.tip.succ == true) {
                    $scope.tip.succ = false;
                }
                $scope.tip.crmpwd = {
                    status:true,
                    txt:"两次密码不一致，请重新输入"
                }
            }
            if ($scope.tip.succ != true) { 
                ToolService.showTips($scope.formTipMsg);
                return false;
            }
            var savePM = HttpService.putInfo("account/updatePwd?oldPassword="+par.pwd+"&newPassword="+par.newpwd,{});;
            ToolService.showLoading();
            savePM.then(function(data){
                ToolService.hideLoading();
                if(data==1){
                    ToolService.showTips("修改成功");
                    window.location.href = "/login.html";
                }
                else{
                    ToolService.showTips("修改失败");
                }
            },function(data){
                ToolService.hideLoading();
                if(data.code == -1001){
                    $scope.tip = {
                        pwd:{
                            status:true,
                            txt:'原密码输入错误，请重新输入'
                        }
                    }
                }
                else{
                    ToolService.showTips("修改失败");
                }
            });
        }
    }
})();