/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.config.app;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.configuration.app.speed.entity.AppSpeedConfig;
import com.dianping.cat.configuration.app.speed.entity.Speed;
import com.dianping.cat.configuration.app.speed.transform.DefaultSaxParser;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppSpeedConfigManager
implements Initializable {
    @Inject
    protected ConfigDao m_configDao;
    @Inject
    private ContentFetcher m_fetcher;
    private volatile Map<String, Speed> m_speeds = new ConcurrentHashMap<String, Speed>();
    private volatile AppSpeedConfig m_config;
    private int m_configId;
    private long m_modifyTime;
    private static final String CONFIG_NAME = "app-speed-config";

    public void initialize() {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_config = DefaultSaxParser.parse(content);
            this.m_modifyTime = config.getModifyDate().getTime();
            this.updateData();
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_config = DefaultSaxParser.parse(content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_config == null) {
            this.m_config = new AppSpeedConfig();
        }
    }

    public int generateId() {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (Speed s : this.m_config.getSpeeds().values()) {
            ids.add(s.getId());
        }
        int max = 0;
        if (!ids.isEmpty()) {
            Collections.sort(ids);
            max = (Integer)ids.get(ids.size() - 1);
        }
        if (ids.size() < max) {
            for (int i = 1; i <= max; ++i) {
                if (ids.contains(i)) continue;
                return i;
            }
        }
        return max + 1;
    }

    public AppSpeedConfig getConfig() {
        return this.m_config;
    }

    public boolean deleteSpeed(int id) {
        this.m_config.removeSpeed(id);
        return this.storeConfig();
    }

    public boolean insert(String xml) {
        try {
            this.m_config = DefaultSaxParser.parse(xml);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean updateConfig(Speed speed) {
        this.m_config.addSpeed(speed);
        return this.storeConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfig() throws DalException, SAXException, IOException {
        Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
        long modifyTime = config.getModifyDate().getTime();
        AppSpeedConfigManager appSpeedConfigManager = this;
        synchronized (appSpeedConfigManager) {
            if (modifyTime > this.m_modifyTime) {
                AppSpeedConfig appConfig;
                String content = config.getContent();
                this.m_config = appConfig = DefaultSaxParser.parse(content);
                this.m_modifyTime = modifyTime;
                this.updateData();
            }
        }
    }

    public int querSpeedThreshold(String page, String step) {
        int value = -1;
        Speed speed = this.m_speeds.get(page + "-" + step);
        if (speed != null) {
            value = speed.getThreshold();
        }
        return value;
    }

    public int querySpeedId(String page, String step) {
        int value = -1;
        Speed speed = this.m_speeds.get(page + "-" + step);
        if (speed != null) {
            value = speed.getId();
        }
        return value;
    }

    public Set<Integer> querySpeedIds() {
        return this.m_config.getSpeeds().keySet();
    }

    private void updateData() {
        Map<Integer, Speed> speeds = this.m_config.getSpeeds();
        ConcurrentHashMap<String, Speed> tmp = new ConcurrentHashMap<String, Speed>();
        for (Map.Entry<Integer, Speed> entry : speeds.entrySet()) {
            Speed s = entry.getValue();
            tmp.put(s.getPage() + "-" + s.getStep(), s);
        }
        this.m_speeds = tmp;
    }

    private boolean storeConfig() {
        try {
            Config config = this.m_configDao.createLocal();
            config.setId(this.m_configId);
            config.setKeyId(this.m_configId);
            config.setName(CONFIG_NAME);
            config.setContent(this.m_config.toString());
            this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            this.updateData();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
        return true;
    }

    public class ConfigReloadTask
    implements Threads.Task {
        public String getName() {
            return "App-Speed-Config-Reload";
        }

        public void run() {
            boolean active = true;
            while (active) {
                try {
                    AppSpeedConfigManager.this.updateConfig();
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    active = false;
                }
            }
        }

        public void shutdown() {
        }
    }
}

