/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.config.web.url;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.config.web.url.UrlPatternHandler;
import com.dianping.cat.configuration.web.url.entity.Code;
import com.dianping.cat.configuration.web.url.entity.PatternItem;
import com.dianping.cat.configuration.web.url.entity.UrlPattern;
import com.dianping.cat.configuration.web.url.transform.DefaultSaxParser;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.tuple.Pair;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlPatternConfigManager
implements Initializable {
    @Inject
    protected ConfigDao m_configDao;
    @Inject
    private UrlPatternHandler m_handler;
    @Inject
    private ContentFetcher m_fetcher;
    private int m_configId;
    private volatile UrlPattern m_urlPattern;
    private long m_modifyTime;
    private static final String CONFIG_NAME = "url-pattern";
    private static final int COMMAND_ID = 500;
    private Map<String, PatternItem> m_format2Items = new ConcurrentHashMap<String, PatternItem>();
    private Map<Integer, PatternItem> m_id2Items = new ConcurrentHashMap<Integer, PatternItem>();

    public boolean deletePatternItem(String key) {
        this.m_urlPattern.removePatternItem(key);
        return this.storeConfig();
    }

    public UrlPattern getUrlPattern() {
        return this.m_urlPattern;
    }

    public Map<Integer, PatternItem> getId2Items() {
        return this.m_id2Items;
    }

    public PatternItem handle(String url) {
        String pattern = this.m_handler.handle(url);
        return this.m_format2Items.get(pattern);
    }

    public Pair<Boolean, Integer> insertPatternItem(PatternItem patternItem) throws Exception {
        int id = this.findAvailableId(1, 500);
        patternItem.setId(id);
        this.m_urlPattern.addPatternItem(patternItem);
        this.m_handler.register(this.queryUrlPatternRules());
        return new Pair((Object)this.storeConfig(), (Object)id);
    }

    public boolean updatePatternItem(PatternItem patternItem) {
        this.m_urlPattern.addPatternItem(patternItem);
        this.m_handler.register(this.queryUrlPatternRules());
        return this.storeConfig();
    }

    public int findAvailableId(int start, int end) throws Exception {
        ArrayList<Integer> keys = new ArrayList<Integer>(this.m_id2Items.keySet());
        Collections.sort(keys);
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (int i = 0; i < keys.size(); ++i) {
            int value = (Integer)keys.get(i);
            if (value < start || value > end) continue;
            tmp.add(value);
        }
        int size = tmp.size();
        if (size == 0) {
            return start;
        }
        if (size == 1) {
            return (Integer)tmp.get(0) + 1;
        }
        if (size == end - start + 1) {
            RuntimeException ex = new RuntimeException();
            Cat.logError((String)("app config range is full: " + start + " - " + end), (Throwable)ex);
            throw ex;
        }
        int key = (Integer)tmp.get(0);
        int last = key;
        for (int i = 0; i < size; ++i) {
            key = (Integer)tmp.get(i);
            if (key - last > 1) {
                return last + 1;
            }
            last = key;
        }
        return last + 1;
    }

    public void initialize() {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_urlPattern = DefaultSaxParser.parse(content);
            this.m_modifyTime = config.getModifyDate().getTime();
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_urlPattern = DefaultSaxParser.parse(content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_urlPattern == null) {
            this.m_urlPattern = new UrlPattern();
        }
        this.m_handler.register(this.queryUrlPatternRules());
        this.refreshData();
        Threads.forGroup((String)"cat").start((Runnable)((Object)new ConfigReloadTask()));
    }

    public boolean insert(String xml) {
        try {
            this.m_urlPattern = DefaultSaxParser.parse(xml);
            boolean result = this.storeConfig();
            return result;
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean isSuccessCode(int code) {
        Code c = this.m_urlPattern.getCodes().get(code);
        if (c != null) {
            return c.getStatus() == 0;
        }
        return false;
    }

    public Map<Integer, Code> queryCodes() {
        return this.m_urlPattern.getCodes();
    }

    public PatternItem queryPatternById(int id) {
        return this.m_id2Items.get(id);
    }

    public PatternItem queryUrlPattern(String key) {
        return this.m_urlPattern.findPatternItem(key);
    }

    public Collection<PatternItem> queryUrlPatternRules() {
        return this.m_urlPattern.getPatternItems().values();
    }

    public Map<String, PatternItem> queryUrlPatterns() {
        return this.m_urlPattern.getPatternItems();
    }

    public void refreshData() {
        HashMap<String, PatternItem> format2Items = new HashMap<String, PatternItem>();
        HashMap<Integer, PatternItem> id2Items = new HashMap<Integer, PatternItem>();
        for (PatternItem item : this.m_urlPattern.getPatternItems().values()) {
            format2Items.put(item.getPattern(), item);
            id2Items.put(item.getId(), item);
        }
        this.m_format2Items = format2Items;
        this.m_id2Items = id2Items;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUrlPatternConfig() throws DalException, SAXException, IOException {
        Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
        long modifyTime = config.getModifyDate().getTime();
        UrlPatternConfigManager urlPatternConfigManager = this;
        synchronized (urlPatternConfigManager) {
            if (modifyTime > this.m_modifyTime) {
                UrlPattern pattern;
                String content = config.getContent();
                this.m_urlPattern = pattern = DefaultSaxParser.parse(content);
                this.m_handler.register(this.queryUrlPatternRules());
                this.refreshData();
                this.m_modifyTime = modifyTime;
            }
        }
    }

    private boolean storeConfig() {
        try {
            Config config = this.m_configDao.createLocal();
            config.setId(this.m_configId);
            config.setKeyId(this.m_configId);
            config.setName(CONFIG_NAME);
            config.setContent(this.m_urlPattern.toString());
            this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            this.refreshData();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean updateCode(int id, Code code) {
        this.m_urlPattern.getCodes().put(code.getId(), code);
        return this.storeConfig();
    }

    public class ConfigReloadTask
    implements Threads.Task {
        public String getName() {
            return "UrlPattern-Config-Reload";
        }

        public void run() {
            boolean active = true;
            while (active) {
                try {
                    UrlPatternConfigManager.this.refreshUrlPatternConfig();
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    active = false;
                }
            }
        }

        public void shutdown() {
        }
    }
}

