/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.app.entity;

import com.dianping.cat.configuration.app.BaseEntity;
import com.dianping.cat.configuration.app.IVisitor;
import com.dianping.cat.configuration.app.entity.Code;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Command
extends BaseEntity<Command> {
    private Integer m_id;
    private String m_name;
    private String m_domain;
    private String m_title;
    private boolean m_all = true;
    private int m_threshold = 30;
    private Map<Integer, Code> m_codes = new LinkedHashMap<Integer, Code>();

    public Command() {
    }

    public Command(Integer id) {
        this.m_id = id;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitCommand(this);
    }

    public Command addCode(Code code) {
        this.m_codes.put(code.getId(), code);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Command) {
            Command _o = (Command)obj;
            return this.equals(this.getId(), _o.getId());
        }
        return false;
    }

    public Code findCode(Integer id) {
        return this.m_codes.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Code findOrCreateCode(Integer id) {
        Code code = this.m_codes.get(id);
        if (code == null) {
            Map<Integer, Code> map = this.m_codes;
            synchronized (map) {
                code = this.m_codes.get(id);
                if (code == null) {
                    code = new Code(id);
                    this.m_codes.put(id, code);
                }
            }
        }
        return code;
    }

    public boolean getAll() {
        return this.m_all;
    }

    public Map<Integer, Code> getCodes() {
        return this.m_codes;
    }

    public String getDomain() {
        return this.m_domain;
    }

    public Integer getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public int getThreshold() {
        return this.m_threshold;
    }

    public String getTitle() {
        return this.m_title;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    public boolean isAll() {
        return this.m_all;
    }

    @Override
    public void mergeAttributes(Command other) {
        this.assertAttributeEquals(other, "command", "id", this.m_id, other.getId());
        if (other.getName() != null) {
            this.m_name = other.getName();
        }
        if (other.getDomain() != null) {
            this.m_domain = other.getDomain();
        }
        if (other.getTitle() != null) {
            this.m_title = other.getTitle();
        }
        this.m_all = other.getAll();
        this.m_threshold = other.getThreshold();
    }

    public Code removeCode(Integer id) {
        return this.m_codes.remove(id);
    }

    public Command setAll(boolean all) {
        this.m_all = all;
        return this;
    }

    public Command setDomain(String domain) {
        this.m_domain = domain;
        return this;
    }

    public Command setId(Integer id) {
        this.m_id = id;
        return this;
    }

    public Command setName(String name) {
        this.m_name = name;
        return this;
    }

    public Command setThreshold(int threshold) {
        this.m_threshold = threshold;
        return this;
    }

    public Command setTitle(String title) {
        this.m_title = title;
        return this;
    }
}

