/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.server.filter.entity;

import com.dianping.cat.configuration.server.filter.BaseEntity;
import com.dianping.cat.configuration.server.filter.IVisitor;
import com.dianping.cat.configuration.server.filter.entity.CrashLogDomain;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerFilterConfig
extends BaseEntity<ServerFilterConfig> {
    private Set<String> m_transactionTypes = new LinkedHashSet<String>();
    private Set<String> m_transactionNames = new LinkedHashSet<String>();
    private Set<String> m_domains = new LinkedHashSet<String>();
    private Map<String, CrashLogDomain> m_crashLogDomains = new LinkedHashMap<String, CrashLogDomain>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitServerFilterConfig(this);
    }

    public ServerFilterConfig addCrashLogDomain(CrashLogDomain crashLogDomain) {
        this.m_crashLogDomains.put(crashLogDomain.getId(), crashLogDomain);
        return this;
    }

    public ServerFilterConfig addDomain(String domain) {
        this.m_domains.add(domain);
        return this;
    }

    public ServerFilterConfig addTransactionName(String transactionName) {
        this.m_transactionNames.add(transactionName);
        return this;
    }

    public ServerFilterConfig addTransactionType(String transactionType) {
        this.m_transactionTypes.add(transactionType);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ServerFilterConfig) {
            ServerFilterConfig _o = (ServerFilterConfig)obj;
            if (!this.equals(this.getTransactionTypes(), _o.getTransactionTypes())) {
                return false;
            }
            if (!this.equals(this.getTransactionNames(), _o.getTransactionNames())) {
                return false;
            }
            if (!this.equals(this.getDomains(), _o.getDomains())) {
                return false;
            }
            return this.equals(this.getCrashLogDomains(), _o.getCrashLogDomains());
        }
        return false;
    }

    public CrashLogDomain findCrashLogDomain(String id) {
        return this.m_crashLogDomains.get(id);
    }

    public Map<String, CrashLogDomain> getCrashLogDomains() {
        return this.m_crashLogDomains;
    }

    public Set<String> getDomains() {
        return this.m_domains;
    }

    public Set<String> getTransactionNames() {
        return this.m_transactionNames;
    }

    public Set<String> getTransactionTypes() {
        return this.m_transactionTypes;
    }

    public int hashCode() {
        int hash = 0;
        for (String e : this.m_transactionTypes) {
            hash = hash * 31 + (e == null ? 0 : e.hashCode());
        }
        for (String e : this.m_transactionNames) {
            hash = hash * 31 + (e == null ? 0 : e.hashCode());
        }
        for (String e : this.m_domains) {
            hash = hash * 31 + (e == null ? 0 : e.hashCode());
        }
        hash = hash * 31 + (this.m_crashLogDomains == null ? 0 : this.m_crashLogDomains.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(ServerFilterConfig other) {
    }

    public CrashLogDomain removeCrashLogDomain(String id) {
        return this.m_crashLogDomains.remove(id);
    }
}

