/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.server.transform;

import com.dianping.cat.configuration.server.entity.ConsoleConfig;
import com.dianping.cat.configuration.server.entity.ConsumerConfig;
import com.dianping.cat.configuration.server.entity.Domain;
import com.dianping.cat.configuration.server.entity.HdfsConfig;
import com.dianping.cat.configuration.server.entity.Ldap;
import com.dianping.cat.configuration.server.entity.LongConfig;
import com.dianping.cat.configuration.server.entity.Property;
import com.dianping.cat.configuration.server.entity.ServerConfig;
import com.dianping.cat.configuration.server.entity.StorageConfig;
import com.dianping.cat.configuration.server.transform.IMaker;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSaxMaker
implements IMaker<Attributes> {
    @Override
    public ServerConfig buildConfig(Attributes attributes) {
        String localMode = attributes.getValue("local-mode");
        String jobMachine = attributes.getValue("job-machine");
        String alertMachine = attributes.getValue("alert-machine");
        String hdfsMachine = attributes.getValue("hdfs-machine");
        String sendMachine = attributes.getValue("send-machine");
        ServerConfig config = new ServerConfig();
        if (localMode != null) {
            config.setLocalMode(this.convert(Boolean.class, localMode, null));
        }
        if (jobMachine != null) {
            config.setJobMachine(this.convert(Boolean.class, jobMachine, null));
        }
        if (alertMachine != null) {
            config.setAlertMachine(this.convert(Boolean.class, alertMachine, null));
        }
        if (hdfsMachine != null) {
            config.setHdfsMachine(this.convert(Boolean.class, hdfsMachine, null));
        }
        if (sendMachine != null) {
            config.setSendMachine(this.convert(Boolean.class, sendMachine, null));
        }
        return config;
    }

    @Override
    public ConsoleConfig buildConsole(Attributes attributes) {
        String defaultDomain = attributes.getValue("default-domain");
        String showCatDomain = attributes.getValue("show-cat-domain");
        ConsoleConfig console = new ConsoleConfig();
        if (defaultDomain != null) {
            console.setDefaultDomain(defaultDomain);
        }
        if (showCatDomain != null) {
            console.setShowCatDomain(this.convert(Boolean.class, showCatDomain, null));
        }
        return console;
    }

    @Override
    public ConsumerConfig buildConsumer(Attributes attributes) {
        ConsumerConfig consumer = new ConsumerConfig();
        return consumer;
    }

    @Override
    public Domain buildDomain(Attributes attributes) {
        String name = attributes.getValue("name");
        String urlThreshold = attributes.getValue("url-threshold");
        String sqlThreshold = attributes.getValue("sql-threshold");
        String serviceThreshold = attributes.getValue("service-threshold");
        Domain domain = new Domain(name);
        if (urlThreshold != null) {
            domain.setUrlThreshold(this.convert(Integer.class, urlThreshold, null));
        }
        if (sqlThreshold != null) {
            domain.setSqlThreshold(this.convert(Integer.class, sqlThreshold, null));
        }
        if (serviceThreshold != null) {
            domain.setServiceThreshold(this.convert(Integer.class, serviceThreshold, null));
        }
        return domain;
    }

    @Override
    public HdfsConfig buildHdfs(Attributes attributes) {
        String id = attributes.getValue("id");
        String maxSize = attributes.getValue("max-size");
        String serverUri = attributes.getValue("server-uri");
        String baseDir = attributes.getValue("base-dir");
        HdfsConfig hdfs = new HdfsConfig(id);
        if (maxSize != null) {
            hdfs.setMaxSize(maxSize);
        }
        if (serverUri != null) {
            hdfs.setServerUri(serverUri);
        }
        if (baseDir != null) {
            hdfs.setBaseDir(baseDir);
        }
        return hdfs;
    }

    @Override
    public Ldap buildLdap(Attributes attributes) {
        String ldapUrl = attributes.getValue("ldapUrl");
        Ldap ldap = new Ldap();
        if (ldapUrl != null) {
            ldap.setLdapUrl(ldapUrl);
        }
        return ldap;
    }

    @Override
    public LongConfig buildLongConfig(Attributes attributes) {
        String defaultUrlThreshold = attributes.getValue("default-url-threshold");
        String defaultSqlThreshold = attributes.getValue("default-sql-threshold");
        String defaultServiceThreshold = attributes.getValue("default-service-threshold");
        LongConfig longConfig = new LongConfig();
        if (defaultUrlThreshold != null) {
            longConfig.setDefaultUrlThreshold(this.convert(Integer.class, defaultUrlThreshold, null));
        }
        if (defaultSqlThreshold != null) {
            longConfig.setDefaultSqlThreshold(this.convert(Integer.class, defaultSqlThreshold, null));
        }
        if (defaultServiceThreshold != null) {
            longConfig.setDefaultServiceThreshold(this.convert(Integer.class, defaultServiceThreshold, null));
        }
        return longConfig;
    }

    @Override
    public Property buildProperty(Attributes attributes) {
        String name = attributes.getValue("name");
        String value = attributes.getValue("value");
        Property property = new Property(name);
        if (value != null) {
            property.setValue(value);
        }
        return property;
    }

    @Override
    public StorageConfig buildStorage(Attributes attributes) {
        String localBaseDir = attributes.getValue("local-base-dir");
        String hdfsDisabled = attributes.getValue("hdfs-disabled");
        String uploadThread = attributes.getValue("upload-thread");
        String maxHdfsStorageTime = attributes.getValue("max-hdfs-storage-time");
        String localReportStorageTime = attributes.getValue("local-report-storage-time");
        String localLogivewStorageTime = attributes.getValue("local-logivew-storage-time");
        StorageConfig storage = new StorageConfig();
        if (localBaseDir != null) {
            storage.setLocalBaseDir(localBaseDir);
        }
        if (hdfsDisabled != null) {
            storage.setHdfsDisabled(this.convert(Boolean.class, hdfsDisabled, null));
        }
        if (uploadThread != null) {
            storage.setUploadThread(this.convert(Integer.class, uploadThread, 0));
        }
        if (maxHdfsStorageTime != null) {
            storage.setMaxHdfsStorageTime(this.convert(Integer.class, maxHdfsStorageTime, 0));
        }
        if (localReportStorageTime != null) {
            storage.setLocalReportStorageTime(this.convert(Integer.class, localReportStorageTime, 0));
        }
        if (localLogivewStorageTime != null) {
            storage.setLocalLogivewStorageTime(this.convert(Integer.class, localLogivewStorageTime, 0));
        }
        return storage;
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class || type == Long.TYPE) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class || type == Short.TYPE) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class || type == Float.TYPE) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class || type == Double.TYPE) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class || type == Character.TYPE) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }
}

