/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.server.transform;

import com.dianping.cat.configuration.server.IEntity;
import com.dianping.cat.configuration.server.IVisitor;
import com.dianping.cat.configuration.server.entity.ConsoleConfig;
import com.dianping.cat.configuration.server.entity.ConsumerConfig;
import com.dianping.cat.configuration.server.entity.Domain;
import com.dianping.cat.configuration.server.entity.HdfsConfig;
import com.dianping.cat.configuration.server.entity.Ldap;
import com.dianping.cat.configuration.server.entity.LongConfig;
import com.dianping.cat.configuration.server.entity.Property;
import com.dianping.cat.configuration.server.entity.ServerConfig;
import com.dianping.cat.configuration.server.entity.StorageConfig;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultXmlBuilder
implements IVisitor {
    private IVisitor m_visitor = this;
    private int m_level;
    private StringBuilder m_sb;
    private boolean m_compact;

    public DefaultXmlBuilder() {
        this(false);
    }

    public DefaultXmlBuilder(boolean compact) {
        this(compact, new StringBuilder(4096));
    }

    public DefaultXmlBuilder(boolean compact, StringBuilder sb) {
        this.m_compact = compact;
        this.m_sb = sb;
        this.m_sb.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
    }

    public String buildXml(IEntity<?> entity) {
        entity.accept(this.m_visitor);
        return this.m_sb.toString();
    }

    protected void endTag(String name) {
        --this.m_level;
        this.indent();
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    protected String escape(Object value) {
        return this.escape(value, false);
    }

    protected String escape(Object value, boolean text) {
        if (value == null) {
            return null;
        }
        String str = this.toString(value);
        int len = str.length();
        StringBuilder sb = new StringBuilder(len + 16);
        block6: for (int i = 0; i < len; ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    if (!text) {
                        sb.append("&quot;");
                        continue block6;
                    }
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    protected void indent() {
        if (!this.m_compact) {
            for (int i = this.m_level - 1; i >= 0; --i) {
                this.m_sb.append("   ");
            }
        }
    }

    protected void startTag(String name) {
        this.startTag(name, false, null, new Object[0]);
    }

    protected void startTag(String name, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, (Object)null, closed, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.startTag(name, (Object)null, false, dynamicAttributes, nameValues);
    }

    protected void startTag(String name, Object text, boolean closed, Map<String, String> dynamicAttributes, Object ... nameValues) {
        this.indent();
        this.m_sb.append('<').append(name);
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                this.m_sb.append(' ').append(attrName).append("=\"").append(this.escape(attrValue)).append('\"');
            }
            i += 2;
        }
        if (dynamicAttributes != null) {
            for (Map.Entry<String, String> e : dynamicAttributes.entrySet()) {
                this.m_sb.append(' ').append(e.getKey()).append("=\"").append(this.escape(e.getValue())).append('\"');
            }
        }
        if (text != null && closed) {
            this.m_sb.append('>');
            this.m_sb.append(this.escape(text, true));
            this.m_sb.append("</").append(name).append(">\r\n");
        } else {
            if (closed) {
                this.m_sb.append('/');
            } else {
                ++this.m_level;
            }
            this.m_sb.append(">\r\n");
        }
    }

    protected String toString(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Collection) {
            Collection list = (Collection)value;
            StringBuilder sb = new StringBuilder(32);
            boolean first = true;
            for (Object item : list) {
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (item == null) continue;
                sb.append(item);
            }
            return sb.toString();
        }
        if (value.getClass().isArray()) {
            int len = Array.getLength(value);
            StringBuilder sb = new StringBuilder(32);
            boolean first = true;
            for (int i = 0; i < len; ++i) {
                Object item = Array.get(value, i);
                if (first) {
                    first = false;
                } else {
                    sb.append(',');
                }
                if (item == null) continue;
                sb.append(item);
            }
            return sb.toString();
        }
        return String.valueOf(value);
    }

    protected void tagWithText(String name, String text, Object ... nameValues) {
        if (text == null) {
            return;
        }
        this.indent();
        this.m_sb.append('<').append(name);
        int len = nameValues.length;
        int i = 0;
        while (i + 1 < len) {
            Object attrName = nameValues[i];
            Object attrValue = nameValues[i + 1];
            if (attrValue != null) {
                this.m_sb.append(' ').append(attrName).append("=\"").append(this.escape(attrValue)).append('\"');
            }
            i += 2;
        }
        this.m_sb.append(">");
        this.m_sb.append(this.escape(text, true));
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    protected void element(String name, String text, String defaultValue, boolean escape) {
        if (text == null || text.equals(defaultValue)) {
            return;
        }
        this.indent();
        this.m_sb.append('<').append(name).append(">");
        if (escape) {
            this.m_sb.append(this.escape(text, true));
        } else {
            this.m_sb.append("<![CDATA[").append(text).append("]]>");
        }
        this.m_sb.append("</").append(name).append(">\r\n");
    }

    @Override
    public void visitConfig(ServerConfig config) {
        this.startTag("config", null, "local-mode", config.getLocalMode(), "job-machine", config.getJobMachine(), "alert-machine", config.getAlertMachine(), "hdfs-machine", config.getHdfsMachine(), "send-machine", config.getSendMachine());
        if (config.getStorage() != null) {
            config.getStorage().accept(this.m_visitor);
        }
        if (config.getConsumer() != null) {
            config.getConsumer().accept(this.m_visitor);
        }
        if (config.getConsole() != null) {
            config.getConsole().accept(this.m_visitor);
        }
        if (config.getLdap() != null) {
            config.getLdap().accept(this.m_visitor);
        }
        if (!config.getProperties().isEmpty()) {
            for (Property property : config.getProperties().values()) {
                property.accept(this.m_visitor);
            }
        }
        this.endTag("config");
    }

    @Override
    public void visitConsole(ConsoleConfig console) {
        this.startTag("console", null, "default-domain", console.getDefaultDomain(), "show-cat-domain", console.getShowCatDomain());
        this.element("remote-servers", console.getRemoteServers(), null, true);
        this.endTag("console");
    }

    @Override
    public void visitConsumer(ConsumerConfig consumer) {
        this.startTag("consumer", null, new Object[0]);
        if (consumer.getLongConfig() != null) {
            consumer.getLongConfig().accept(this.m_visitor);
        }
        this.endTag("consumer");
    }

    @Override
    public void visitDomain(Domain domain) {
        this.startTag("domain", true, null, "name", domain.getName(), "url-threshold", domain.getUrlThreshold(), "sql-threshold", domain.getSqlThreshold(), "service-threshold", domain.getServiceThreshold());
    }

    @Override
    public void visitHdfs(HdfsConfig hdfs) {
        this.startTag("hdfs", true, null, "id", hdfs.getId(), "max-size", hdfs.getMaxSize(), "server-uri", hdfs.getServerUri(), "base-dir", hdfs.getBaseDir());
    }

    @Override
    public void visitLdap(Ldap ldap) {
        this.startTag("ldap", true, null, "ldapUrl", ldap.getLdapUrl());
    }

    @Override
    public void visitLongConfig(LongConfig longConfig) {
        this.startTag("long-config", null, "default-url-threshold", longConfig.getDefaultUrlThreshold(), "default-sql-threshold", longConfig.getDefaultSqlThreshold(), "default-service-threshold", longConfig.getDefaultServiceThreshold());
        if (!longConfig.getDomains().isEmpty()) {
            for (Domain domain : longConfig.getDomains().values()) {
                domain.accept(this.m_visitor);
            }
        }
        this.endTag("long-config");
    }

    @Override
    public void visitProperty(Property property) {
        this.startTag("property", true, null, "name", property.getName(), "value", property.getValue());
    }

    @Override
    public void visitStorage(StorageConfig storage) {
        this.startTag("storage", null, "local-base-dir", storage.getLocalBaseDir(), "hdfs-disabled", storage.getHdfsDisabled(), "upload-thread", storage.getUploadThread(), "max-hdfs-storage-time", storage.getMaxHdfsStorageTime(), "local-report-storage-time", storage.getLocalReportStorageTime(), "local-logivew-storage-time", storage.getLocalLogivewStorageTime());
        if (!storage.getHdfses().isEmpty()) {
            for (HdfsConfig hdfs : storage.getHdfses().values()) {
                hdfs.accept(this.m_visitor);
            }
        }
        if (!storage.getProperties().isEmpty()) {
            this.startTag("properties");
            for (Property property : storage.getProperties().values()) {
                property.accept(this.m_visitor);
            }
            this.endTag("properties");
        }
        this.endTag("storage");
    }
}

