/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.web.url.entity;

import com.dianping.cat.configuration.web.url.BaseEntity;
import com.dianping.cat.configuration.web.url.IVisitor;
import com.dianping.cat.configuration.web.url.entity.Code;
import com.dianping.cat.configuration.web.url.entity.PatternItem;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlPattern
extends BaseEntity<UrlPattern> {
    private Map<String, PatternItem> m_patternItems = new LinkedHashMap<String, PatternItem>();
    private Map<Integer, Code> m_codes = new LinkedHashMap<Integer, Code>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitUrlPattern(this);
    }

    public UrlPattern addCode(Code code) {
        this.m_codes.put(code.getId(), code);
        return this;
    }

    public UrlPattern addPatternItem(PatternItem patternItem) {
        this.m_patternItems.put(patternItem.getName(), patternItem);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UrlPattern) {
            UrlPattern _o = (UrlPattern)obj;
            if (!this.equals(this.getPatternItems(), _o.getPatternItems())) {
                return false;
            }
            return this.equals(this.getCodes(), _o.getCodes());
        }
        return false;
    }

    public Code findCode(Integer id) {
        return this.m_codes.get(id);
    }

    public PatternItem findPatternItem(String name) {
        return this.m_patternItems.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Code findOrCreateCode(Integer id) {
        Code code = this.m_codes.get(id);
        if (code == null) {
            Map<Integer, Code> map = this.m_codes;
            synchronized (map) {
                code = this.m_codes.get(id);
                if (code == null) {
                    code = new Code(id);
                    this.m_codes.put(id, code);
                }
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PatternItem findOrCreatePatternItem(String name) {
        PatternItem patternItem = this.m_patternItems.get(name);
        if (patternItem == null) {
            Map<String, PatternItem> map = this.m_patternItems;
            synchronized (map) {
                patternItem = this.m_patternItems.get(name);
                if (patternItem == null) {
                    patternItem = new PatternItem(name);
                    this.m_patternItems.put(name, patternItem);
                }
            }
        }
        return patternItem;
    }

    public Map<Integer, Code> getCodes() {
        return this.m_codes;
    }

    public Map<String, PatternItem> getPatternItems() {
        return this.m_patternItems;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_patternItems == null ? 0 : this.m_patternItems.hashCode());
        hash = hash * 31 + (this.m_codes == null ? 0 : this.m_codes.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(UrlPattern other) {
    }

    public Code removeCode(Integer id) {
        return this.m_codes.remove(id);
    }

    public PatternItem removePatternItem(String name) {
        return this.m_patternItems.remove(name);
    }
}

