/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.web.url.transform;

import com.dianping.cat.configuration.web.url.IVisitor;
import com.dianping.cat.configuration.web.url.entity.Code;
import com.dianping.cat.configuration.web.url.entity.PatternItem;
import com.dianping.cat.configuration.web.url.entity.UrlPattern;
import com.dianping.cat.configuration.web.url.transform.DefaultLinker;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

public class DefaultNativeParser
implements IVisitor {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private DataInputStream m_in;

    public DefaultNativeParser(InputStream in) {
        this.m_in = new DataInputStream(in);
    }

    public static UrlPattern parse(byte[] data) {
        return DefaultNativeParser.parse(new ByteArrayInputStream(data));
    }

    public static UrlPattern parse(InputStream in) {
        UrlPattern urlPattern;
        DefaultNativeParser parser;
        block2: {
            parser = new DefaultNativeParser(in);
            urlPattern = new UrlPattern();
            try {
                urlPattern.accept(parser);
            }
            catch (RuntimeException e) {
                if (e.getCause() != null && e.getCause() instanceof EOFException) break block2;
                throw e;
            }
        }
        parser.m_linker.finish();
        return urlPattern;
    }

    public void visitCode(Code code) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitCodeChildren(code, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitCodeChildren(Code code, int _field, int _type) {
        switch (_field) {
            case 1: {
                code.setId(this.readInt());
                break;
            }
            case 2: {
                code.setName(this.readString());
                break;
            }
            case 3: {
                code.setStatus(this.readInt());
            }
        }
    }

    public void visitPatternItem(PatternItem patternItem) {
        byte tag;
        while ((tag = this.readTag()) != -1) {
            this.visitPatternItemChildren(patternItem, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitPatternItemChildren(PatternItem patternItem, int _field, int _type) {
        switch (_field) {
            case 1: {
                patternItem.setGroup(this.readString());
                break;
            }
            case 2: {
                patternItem.setName(this.readString());
                break;
            }
            case 3: {
                patternItem.setPattern(this.readString());
                break;
            }
            case 4: {
                patternItem.setDomain(this.readString());
                break;
            }
            case 5: {
                patternItem.setId(this.readInt());
            }
        }
    }

    public void visitUrlPattern(UrlPattern urlPattern) {
        byte tag = this.readTag();
        if (tag != -4) {
            throw new RuntimeException(String.format("Malformed payload, expected: %s, but was: %s!", -4, tag));
        }
        while ((tag = this.readTag()) != -1) {
            this.visitUrlPatternChildren(urlPattern, (tag & 0xFF) >> 2, tag & 3);
        }
    }

    protected void visitUrlPatternChildren(UrlPattern urlPattern, int _field, int _type) {
        switch (_field) {
            case 33: {
                if (_type == 1) {
                    PatternItem patternItem = new PatternItem();
                    this.visitPatternItem(patternItem);
                    this.m_linker.onPatternItem(urlPattern, patternItem);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    PatternItem patternItem = new PatternItem();
                    this.visitPatternItem(patternItem);
                    this.m_linker.onPatternItem(urlPattern, patternItem);
                }
                break;
            }
            case 34: {
                if (_type == 1) {
                    Code code = new Code();
                    this.visitCode(code);
                    this.m_linker.onCode(urlPattern, code);
                    break;
                }
                if (_type != 2) break;
                for (int i = this.readInt(); i > 0; --i) {
                    Code code = new Code();
                    this.visitCode(code);
                    this.m_linker.onCode(urlPattern, code);
                }
                break;
            }
        }
    }

    private int readInt() {
        try {
            return (int)this.readVarint(32);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readString() {
        try {
            return this.m_in.readUTF();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private byte readTag() {
        try {
            return this.m_in.readByte();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected long readVarint(int length) throws IOException {
        long result = 0L;
        for (int shift = 0; shift < length; shift += 7) {
            byte b = this.m_in.readByte();
            result |= (long)(b & 0x7F) << shift;
            if ((b & 0x80) != 0) continue;
            return result;
        }
        throw new RuntimeException("Malformed variable int " + length + "!");
    }
}

