/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.storage;

import com.dianping.cat.Cat;
import com.dianping.cat.message.internal.MessageId;
import com.dianping.cat.message.spi.MessageCodec;
import com.dianping.cat.message.spi.MessageTree;
import com.dianping.cat.message.spi.internal.DefaultMessageTree;
import com.dianping.cat.message.storage.MessageBlock;
import com.dianping.cat.message.storage.MessageBlockReader;
import com.dianping.cat.message.storage.MessageBlockWriter;
import com.dianping.cat.message.storage.MessageBucket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.GZIPOutputStream;
import org.unidal.lookup.annotation.Inject;

public class LocalMessageBucket
implements MessageBucket {
    public static final String ID = "local";
    private static final int MAX_BLOCK_SIZE = 65536;
    @Inject
    private MessageCodec m_codec;
    private File m_baseDir = new File(".");
    private MessageBlockReader m_reader;
    private MessageBlockWriter m_writer;
    private AtomicBoolean m_dirty = new AtomicBoolean();
    private String m_dataFile;
    private long m_lastAccessTime;
    private GZIPOutputStream m_out;
    private ByteArrayOutputStream m_buf;
    private MessageBlock m_block;
    private int m_blockSize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        LocalMessageBucket localMessageBucket = this;
        synchronized (localMessageBucket) {
            if (this.m_reader != null) {
                this.m_reader.close();
                this.m_writer.close();
                this.m_out.close();
                this.m_buf.close();
                this.m_out = null;
                this.m_buf = null;
                this.m_reader = null;
                this.m_writer = null;
            }
        }
    }

    public MessageTree findById(String messageId) throws IOException {
        int index = MessageId.parse((String)messageId).getIndex();
        return this.findByIndex(index);
    }

    public MessageTree findByIndex(int index) throws IOException {
        try {
            this.m_lastAccessTime = System.currentTimeMillis();
            byte[] data = this.m_reader.readMessage(index);
            ByteBuf buf = ByteBufAllocator.DEFAULT.buffer(data.length);
            DefaultMessageTree tree = new DefaultMessageTree();
            buf.writeBytes(data);
            this.m_codec.decode(buf, (MessageTree)tree);
            return tree;
        }
        catch (EOFException e) {
            Cat.logError((Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageBlock flushBlock() throws IOException {
        if (this.m_dirty.get()) {
            LocalMessageBucket localMessageBucket = this;
            synchronized (localMessageBucket) {
                MessageBlock messageBlock;
                this.m_out.close();
                byte[] data = this.m_buf.toByteArray();
                try {
                    this.m_block.setData(data);
                    this.m_blockSize = 0;
                    this.m_buf.reset();
                    this.m_out = new GZIPOutputStream(this.m_buf);
                    this.m_dirty.set(false);
                    messageBlock = this.m_block;
                    this.m_block = new MessageBlock(this.m_dataFile);
                }
                catch (Throwable throwable) {
                    this.m_block = new MessageBlock(this.m_dataFile);
                    throw throwable;
                }
                return messageBlock;
            }
        }
        return null;
    }

    public long getLastAccessTime() {
        return this.m_lastAccessTime;
    }

    public MessageBlockWriter getWriter() {
        return this.m_writer;
    }

    public void initialize(String dataFile) throws IOException {
        this.m_dataFile = dataFile;
        File file = new File(this.m_baseDir, dataFile);
        this.m_writer = new MessageBlockWriter(file);
        this.m_reader = new MessageBlockReader(file);
        this.m_block = new MessageBlock(this.m_dataFile);
        this.m_buf = new ByteArrayOutputStream(16384);
        this.m_out = new GZIPOutputStream(this.m_buf);
    }

    public void setBaseDir(File baseDir) {
        this.m_baseDir = baseDir;
    }

    public void setMessageCodec(MessageCodec codec) {
        this.m_codec = codec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageBlock storeMessage(ByteBuf buf, MessageId id) throws IOException {
        LocalMessageBucket localMessageBucket = this;
        synchronized (localMessageBucket) {
            int size = buf.readableBytes();
            this.m_dirty.set(true);
            this.m_lastAccessTime = System.currentTimeMillis();
            this.m_blockSize += size;
            this.m_block.addIndex(id.getIndex(), size);
            buf.getBytes(0, (OutputStream)this.m_out, size);
            if (this.m_blockSize >= 65536) {
                return this.flushBlock();
            }
            return null;
        }
    }
}

