/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report;

import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.message.PathBuilder;
import com.dianping.cat.report.ReportBucket;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import org.unidal.helper.Splitters;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.logging.LogEnabled;
import org.unidal.lookup.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalReportBucket
implements ReportBucket,
LogEnabled {
    @Inject
    private PathBuilder m_pathBuilder;
    @Inject
    private ServerConfigManager m_configManager;
    private String m_baseDir = "target/bucket/report";
    private Map<String, Long> m_idToOffsets = new HashMap<String, Long>();
    private Map<String, List<String>> m_tagToIds = new HashMap<String, List<String>>();
    private ReentrantLock m_readLock;
    private RandomAccessFile m_readDataFile;
    private ReentrantLock m_writeLock;
    private long m_writeDataFileLength;
    private OutputStream m_writeDataFile;
    private OutputStream m_writeIndexFile;
    private Logger m_logger;
    private String m_logicalPath;

    @Override
    public void close() throws IOException {
        this.m_writeLock.lock();
        try {
            this.m_idToOffsets.clear();
            this.m_tagToIds.clear();
            this.m_writeDataFile.close();
            this.m_writeIndexFile.close();
            this.m_readDataFile.close();
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String findById(String id) throws IOException {
        Long offset = this.m_idToOffsets.get(id);
        if (offset != null) {
            this.m_readLock.lock();
            try {
                this.m_readDataFile.seek(offset);
                int num = Integer.parseInt(this.m_readDataFile.readLine());
                byte[] bytes = new byte[num];
                this.m_readDataFile.readFully(bytes);
                String string = new String(bytes, "utf-8");
                return string;
            }
            catch (Exception e) {
                this.m_logger.error(String.format("Error when reading file(%s)!", this.m_readDataFile), (Throwable)e);
            }
            finally {
                this.m_readLock.unlock();
            }
        }
        return null;
    }

    @Override
    public void flush() throws IOException {
        this.m_writeLock.lock();
        try {
            this.m_writeDataFile.flush();
            this.m_writeIndexFile.flush();
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    public String getBaseDir() {
        return this.m_baseDir;
    }

    @Override
    public Collection<String> getIds() {
        return this.m_idToOffsets.keySet();
    }

    public String getLogicalPath() {
        return this.m_logicalPath;
    }

    @Override
    public void initialize(String name, Date timestamp, int index) throws IOException {
        File dir;
        this.m_baseDir = this.m_configManager.getHdfsLocalBaseDir("report");
        this.m_writeLock = new ReentrantLock();
        this.m_readLock = new ReentrantLock();
        String logicalPath = this.m_pathBuilder.getReportPath(name, timestamp, index);
        File dataFile = new File(this.m_baseDir, logicalPath);
        File indexFile = new File(this.m_baseDir, logicalPath + ".idx");
        if (indexFile.exists()) {
            this.loadIndexes(indexFile);
        }
        if (!(dir = dataFile.getParentFile()).exists() && !dir.mkdirs()) {
            throw new IOException(String.format("Fail to create directory(%s)!", dir));
        }
        this.m_logicalPath = logicalPath;
        this.m_writeDataFile = new BufferedOutputStream(new FileOutputStream(dataFile, true), 8192);
        this.m_writeIndexFile = new BufferedOutputStream(new FileOutputStream(indexFile, true), 8192);
        this.m_writeDataFileLength = dataFile.length();
        this.m_readDataFile = new RandomAccessFile(dataFile, "r");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadIndexes(File indexFile) throws IOException {
        BufferedReader reader = null;
        this.m_writeLock.lock();
        try {
            String line;
            reader = new BufferedReader(new FileReader(indexFile));
            Splitters.StringSplitter splitter = Splitters.by((char)'\t');
            while ((line = reader.readLine()) != null) {
                List parts = splitter.split(line);
                if (parts.size() < 2) continue;
                String id = (String)parts.remove(0);
                String offset = (String)parts.remove(0);
                try {
                    this.m_idToOffsets.put(id, Long.parseLong(offset));
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        finally {
            this.m_writeLock.unlock();
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean storeById(String id, String report) throws IOException {
        byte[] content = report.getBytes("utf-8");
        int length = content.length;
        byte[] num = String.valueOf(length).getBytes("utf-8");
        this.m_writeLock.lock();
        try {
            this.m_writeDataFile.write(num);
            this.m_writeDataFile.write(10);
            this.m_writeDataFile.write(content);
            this.m_writeDataFile.write(10);
            this.m_writeDataFile.flush();
            long offset = this.m_writeDataFileLength;
            String line = id + '\t' + offset + '\n';
            byte[] data = line.getBytes("utf-8");
            this.m_writeDataFileLength += (long)(num.length + 1 + length + 1);
            this.m_writeIndexFile.write(data);
            this.m_writeIndexFile.flush();
            this.m_idToOffsets.put(id, offset);
            boolean bl = true;
            return bl;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }
}

