/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.service;

import com.dianping.cat.analysis.AbstractMessageAnalyzer;
import com.dianping.cat.analysis.MessageAnalyzer;
import com.dianping.cat.analysis.MessageConsumer;
import com.dianping.cat.analysis.RealtimeConsumer;
import com.dianping.cat.config.server.ServerConfigManager;
import com.dianping.cat.mvc.ApiPayload;
import com.dianping.cat.report.service.ModelPeriod;
import com.dianping.cat.report.service.ModelRequest;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocalModelService<T>
implements Initializable {
    @Inject(type=MessageConsumer.class)
    private RealtimeConsumer m_consumer;
    @Inject
    protected ServerConfigManager m_manager;
    public static final int DEFAULT_SIZE = 32768;
    public static final int ANALYZER_COUNT = 2;
    private String m_defaultDomain = "cat";
    private String m_name;

    public LocalModelService(String name) {
        this.m_name = name;
    }

    public abstract String buildReport(ModelRequest var1, ModelPeriod var2, String var3, ApiPayload var4) throws Exception;

    public String getName() {
        return this.m_name;
    }

    protected List<T> getReport(ModelPeriod period, String domain) throws Exception {
        List<MessageAnalyzer> analyzers = null;
        if (domain == null || domain.length() == 0) {
            domain = this.m_defaultDomain;
        }
        if (period.isCurrent()) {
            analyzers = this.m_consumer.getCurrentAnalyzer(this.m_name);
        } else if (period.isLast()) {
            analyzers = this.m_consumer.getLastAnalyzer(this.m_name);
        }
        if (analyzers == null) {
            return null;
        }
        ArrayList list = new ArrayList();
        for (MessageAnalyzer a : analyzers) {
            list.add(((AbstractMessageAnalyzer)a).getReport(domain));
        }
        return list;
    }

    public String getReport(ModelRequest request, ModelPeriod period, String domain, ApiPayload payload) throws Exception {
        try {
            return this.buildReport(request, period, domain, payload);
        }
        catch (ConcurrentModificationException e) {
            return this.buildReport(request, period, domain, payload);
        }
    }

    public void initialize() throws InitializationException {
        this.m_defaultDomain = this.m_manager.getConsoleDefaultDomain();
    }

    public boolean isEligable(ModelRequest request) {
        ModelPeriod period = request.getPeriod();
        return !period.isHistorical();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(this.getClass().getSimpleName()).append('[');
        sb.append("name=").append(this.m_name);
        sb.append(']');
        return sb.toString();
    }
}

