/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.converter.dom;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.unidal.converter.Converter;
import org.unidal.converter.ConverterException;
import org.unidal.converter.ConverterManager;
import org.unidal.converter.TypeUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NodeListConverter
implements Converter<Object> {
    @Override
    public boolean canConvert(Type fromType, Type targetType) {
        Class<?> fromClass = TypeUtil.getRawType(fromType);
        return Node.class.isAssignableFrom(fromClass);
    }

    @Override
    public Object convert(Object from, Type targetType) throws ConverterException {
        Node node = (Node)from;
        NodeList children = node.getChildNodes();
        int size = children.getLength();
        ArrayList<Object> list = new ArrayList<Object>(size);
        Type componentType = TypeUtil.getComponentType(targetType);
        Class<?> rawComponentType = TypeUtil.getRawType(componentType);
        for (int j = 0; j < size; ++j) {
            Node child = children.item(j);
            if (child.getNodeType() == 8) continue;
            if (rawComponentType.isAssignableFrom(child.getClass())) {
                list.add(child);
                continue;
            }
            try {
                Object text = ConverterManager.getInstance().convert(child, (Type)((Object)String.class));
                list.add(text);
                continue;
            }
            catch (ConverterException e) {
                list.add(child);
            }
        }
        Object value = ConverterManager.getInstance().convert(list.toArray(), targetType);
        return value;
    }

    @Override
    public Type getTargetType() {
        return List.class;
    }
}

