/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.container;

public class ComponentKey {
    private String m_role;
    private String m_roleHint;

    public ComponentKey(Class<?> type, String roleHint) {
        this(type.getName(), roleHint);
    }

    public ComponentKey(String role, String roleHint) {
        this.m_role = role;
        this.m_roleHint = this.normalize(roleHint);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ComponentKey) {
            ComponentKey o = (ComponentKey)obj;
            return o.m_role.equals(this.m_role) && o.m_roleHint.equals(this.m_roleHint);
        }
        return false;
    }

    public String getRole() {
        return this.m_role;
    }

    public String getRoleHint() {
        return this.m_roleHint;
    }

    public int hashCode() {
        return this.m_role.hashCode() * 31 + this.m_roleHint.hashCode();
    }

    public boolean matches(String role, String roleHint) {
        if (this.m_role.equals(role)) {
            return this.m_roleHint.equals(this.normalize(roleHint));
        }
        return false;
    }

    private String normalize(String roleHint) {
        if (roleHint == null || roleHint.length() == 0) {
            return "default";
        }
        return roleHint;
    }

    public String toString() {
        return String.format("%s[role=%s, roleHint=%s]", this.getClass().getSimpleName(), this.m_role, this.m_roleHint);
    }
}

