package com.reyun.controller.manage;

import com.reyun.dic.LogEnumType;
import com.reyun.dic.OperateObjectEnumType;
import com.reyun.model.Account;
import com.reyun.model.SystemParam;
import com.reyun.security.annotation.CurrentAccount;
import com.reyun.service.SystemParamService;
import com.reyun.service.UserLogService;
import com.reyun.util.ResultModel;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.servlet.http.HttpServletRequest;

@Controller
@RequestMapping("/mng/systemparam")
public class MngSystemParamController {
	protected Logger logger = LoggerFactory.getLogger(MngSystemParamController.class);
	
	@Autowired
	SystemParamService systemParameterService;

	@Autowired
	UserLogService userLogService;

	
	@RequestMapping(value = "update",method = RequestMethod.PUT)
	@ResponseBody
	public ResultModel update(HttpServletRequest request,
			@RequestBody SystemParam resource,
			@CurrentAccount Account currentAccount) {
		Long account = currentAccount.getId();
		if (!currentAccount.getIsSuperUser()) {
			account = currentAccount.getParent();
		}
		SystemParam systemParam = systemParameterService.update(resource,account);
		userLogService.insertLog(currentAccount, LogEnumType.UPDATE.getCode(), LogEnumType.UPDATE.getName() + "推广参数" , systemParam,null,OperateObjectEnumType.SYSTEM_PARAM.getCode());
		return ResultModel.OK();
	}
	
	@RequestMapping(value = "find",method = RequestMethod.GET)
	@ResponseBody
	public ResultModel find(HttpServletRequest request, @CurrentAccount Account loginAccount) {
		Long account = loginAccount.getId();
		if (!loginAccount.getIsSuperUser()) {
			account = loginAccount.getParent();
		}
		SystemParam find = systemParameterService.find(account);
		userLogService.insertLog(loginAccount, LogEnumType.FIND.getCode(), LogEnumType.FIND.getName() + "推广参数" , find,null,OperateObjectEnumType.SYSTEM_PARAM.getCode());
		return ResultModel.OK(find);
	}
}
