package com.reyun.model;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;

@Entity
public class UserLog {

	private Long id;
	private String type;
	private String email;
	private boolean isMasterLogin;
	private String operaType;
	
	@Column(length=2000)
	private String operaContent;
	private Date pubDate = new Date();
	private String ds;
	
	
	private Long app;
	private String appName;
	
	private String objectType;

	private String ip;

	private String location;

	public UserLog() {
		super();
	}


	public String getEmail() {
		return email;
	}

	@Id
	@GeneratedValue
	public Long getId() {
		return id;
	}

	public Date getPubDate() {
		return pubDate;
	}


	public void setEmail(String email) {
		this.email = email;
	}

	public void setId(Long id) {
		this.id = id;
	}


	public void setPubDate(Date pubDate) {
		this.pubDate = pubDate;
	}


	public String getOperaType() {
		return operaType;
	}


	public void setOperaType(String operaType) {
		this.operaType = operaType;
	}


	public String getOperaContent() {
		return operaContent;
	}


	public void setOperaContent(String operaContent) {
		this.operaContent = operaContent;
	}


	public String getType() {
		return type;
	}


	public void setType(String type) {
		this.type = type;
	}


	public String getDs() {
		return ds;
	}


	public void setDs(String ds) {
		this.ds = ds;
	}


	public Long getApp() {
		return app;
	}


	public void setApp(Long app) {
		this.app = app;
	}


	public String getAppName() {
		return appName;
	}


	public void setAppName(String appName) {
		this.appName = appName;
	}


	public String getObjectType() {
		return objectType;
	}


	public void setObjectType(String objectType) {
		this.objectType = objectType;
	}


	public String getIp() {
		return ip;
	}


	public void setIp(String ip) {
		this.ip = ip;
	}


	public String getLocation() {
		return location;
	}


	public void setLocation(String location) {
		this.location = location;
	}


	public boolean isMasterLogin() {
		return isMasterLogin;
	}


	public void setMasterLogin(boolean isMasterLogin) {
		this.isMasterLogin = isMasterLogin;
	}

	@Override
	public String toString()
	{
		return "UserLog{" +
				"id=" + id +
				", type='" + type + '\'' +
				", email='" + email + '\'' +
				", isMasterLogin=" + isMasterLogin +
				", operaType='" + operaType + '\'' +
				", operaContent='" + operaContent + '\'' +
				", pubDate=" + pubDate +
				", ds='" + ds + '\'' +
				", app=" + app +
				", appName='" + appName + '\'' +
				", objectType='" + objectType + '\'' +
				", ip='" + ip + '\'' +
				", location='" + location + '\'' +
				'}';
	}
}
