/*
package com.reyun.ops;

import com.amazonaws.services.dynamodbv2.document.*;
import com.amazonaws.services.dynamodbv2.model.WriteRequest;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.reyun.model.SurlModel;
import com.reyun.util.*;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.*;
import java.util.*;
import java.util.Date;
import java.util.concurrent.*;

*/
/**
 * Created by nolan on 13/02/2017.
 * description:
 *//*

public class SurlOpsMain {
	private final static Logger logger = LoggerFactory.getLogger(SurlOpsMain.class);

	public static void main(String[] args) {
		if (Constant.awsneed) {
			updateAWSRedis();
		}
	}

	public static List<SurlModel> updateAWSDynamodb(Long appid, int threadsize, final int recordsize, boolean isTest) throws SQLException, InterruptedException {
		logger.info("启动配置: 线程数/{}, 单线程处理记录数/{}", threadsize, recordsize);
		final List<SurlModel> list;
		if (appid != null) {
			list = querySurlByAppId(appid);
		} else {
			list = queryAllSurls();
		}

		final Integer totalnum;
		final Integer pagenum;
		if(isTest){
			pagenum = 1;
			totalnum = recordsize;
		}else {
			totalnum = list != null ? list.size() : 0;
			pagenum = totalnum % recordsize == 0 ? totalnum / recordsize : totalnum / recordsize + 1;
		}
		logger.info("总计记录数:{},总页数: {}......", totalnum, pagenum);

		List<SurlModel> rtnList = Lists.newArrayList();
		ExecutorService exec = Executors.newFixedThreadPool(threadsize);
		final Semaphore semaphore = new Semaphore(threadsize);
		List<Future<List<SurlModel>>> cblist = Lists.newArrayList();
		for (int i = 0; i < pagenum; i++) {
			try {
				semaphore.acquire();
			} catch (InterruptedException e) {
				logger.error("InterruptedException pagenum:{}", i);
				e.printStackTrace();
				throw e;
			}

			logger.info("运行第{}页, 每页{}条......", i+1, recordsize);
			final int index = i;
			cblist.add(exec.submit(new Callable<List<SurlModel>>() {
				@Override
				public List<SurlModel> call() throws Exception {
					List<SurlModel> subtasklist = list.subList(index * recordsize, (index + 1) == pagenum ? totalnum : ((index + 1) * recordsize));
					if (subtasklist == null || subtasklist.size() == 0)
						return Lists.newArrayList();

					List<SurlModel> errorList = Lists.newArrayList();
					List<Item> awsitemlist = Lists.newArrayList();
					for (SurlModel item : subtasklist) {
						Map<String, Object> attributes = BeanUtils.bean2Map(item);
						attributes = Maps.filterValues(attributes, new Predicate<Object>() {
							@Override
							public boolean apply(Object s) {
								return s != null && !Strings.isNullOrEmpty(String.valueOf(s));
							}
						});

						if(!attributes.containsKey("surl")){
							errorList.add(item);
						}else{
							awsitemlist.add(Item.fromMap(attributes));
						}
					}
					BatchWriteItemOutcome batchWriteItemOutcome = null;
					try {
						batchWriteItemOutcome = DynamoDBUtil.getInstance().getDynamoDB().batchWriteItem(new TableWriteItems(SurlModel.TABLE).withItemsToPut(awsitemlist));
					} catch (Exception e) {
						logger.info("awsitemlist: {}", awsitemlist);
						throw e;
					}
					do {
						Map<String, List<WriteRequest>> unprocessedItems = batchWriteItemOutcome.getUnprocessedItems();

						if (batchWriteItemOutcome.getUnprocessedItems().size() == 0) {
							logger.info("No unprocessed items found");
						} else {
							batchWriteItemOutcome = DynamoDBUtil.getInstance().getDynamoDB().batchWriteItemUnprocessed(unprocessedItems);
						}

					} while (batchWriteItemOutcome.getUnprocessedItems().size() > 0);
					semaphore.release();
					return errorList;
				}
			}));
		}
		for(Future<List<SurlModel>> cb : cblist){
			try {
				final List<SurlModel>  c = cb.get();
				if (c != null && c.size() > 0) {
					rtnList.addAll(c);
				}
			} catch (ExecutionException e) {
				e.printStackTrace();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}
		exec.shutdown();

		logger.info("总计记录数:{},总页数: {}......//END", totalnum, pagenum);
		return rtnList;
	}



	public static void updateAWSRedis() {
		if (Constant.awsneed) {
			List<Map<String, String>> dbList = new ArrayList<Map<String, String>>();
			try {
				dbList = queryAWSFalse();
			} catch (SQLException e) {
				String subject = "Fail to query data from DB, which need to update to AWS redis.";
				try {
					MailUtils.sendSimpleEmail(subject, subject, Constant.mlist);
				} catch (Exception e1) {
					logger.error("Fail to send email to inform fail of query data from DB" + e1.getMessage());
				}
			}
			if (dbList.size() > 0) {
				InetAddress addr = null;
				try {
					addr = InetAddress.getLocalHost();
				} catch (UnknownHostException e) {
					logger.error("Fail to get local ip.." + e.getMessage());
				}
				String ip = addr!=null?addr.getHostAddress():"";
				String tokenStr = "zhangxiaoyan_" + DateUtil.format(new Date(), DateUtil.C_DATE_PATTON_DEFAULT);
				String token = CipherUtil.generatePassword(tokenStr);
				List<String> surlList = new ArrayList<String>();
				List<String> campaignpackidList = new ArrayList<String>();
				for (Map<String, String> m : dbList) {
					Map attributes = Maps.filterValues(m, new Predicate<Object>() {
						@Override
						public boolean apply(Object s) {
							return s != null && !Strings.isNullOrEmpty(String.valueOf(s));
						}
					});
					Table tableModel = DynamoDBUtil.getInstance().getTable(SurlModel.TABLE);
					final PutItemOutcome putItemOutcome = tableModel.putItem(Item.fromMap(attributes));
					boolean isflag = putItemOutcome.getPutItemResult().getSdkHttpMetadata().getHttpStatusCode() == 200;
					if(!isflag){
						logger.error("Fail to update AWS dynamodb campaigninfo by surl: {}.", m.get("surl"));
					}

					m.put("method", "update");
					m.put("token", token);
					try {
						boolean success = HttpClientUtil.httpAWS(m, ip, m.get("surl"), Constant.awsurl);
						if (success) {
							if (!StringUtil.isEmpty(m.get("category")) && m.get("category").equals("APPMARKET")) {
								String sac = m.get("surl");
								String[] sacs = sac.split(":");
								campaignpackidList.add(sacs[1]);
							} else {
								surlList.add(m.get("surl"));
							}
						}
					} catch (Exception e) {
						logger.error("Fail to update AWS redis campaigninfo by surl:" + m.get("surl") + "from database..." + e.getMessage());
					}
				}
				if (surlList.size() > 0) {
					String surlstr = "'" + StringUtils.join(surlList, "','") + "'";
					try {
						updateStatusInMysql(surlstr);
					} catch (SQLException e) {
						logger.error("Fail to update db table campaign's awssuccess filed." + e.getMessage());
					}
				}
				if (campaignpackidList.size() > 0) {
					String idstr = "'" + StringUtils.join(campaignpackidList, "','") + "'";
					try {
						updateStatusInMysqlId(idstr);
					} catch (SQLException e) {
						logger.error("Fail to update db table campaign's awssuccess filed." + e.getMessage());
					}
				}
			} else {
				logger.info("There is no data need to update AWS redis...");
			}
		}
	}


	public static List<Map<String, String>> queryAWSFalse() throws SQLException {
		DBUtil dbUtil = DBUtil.newInstance();
		String sql = "select c.channel, c.channelid,c.name,c.url,c.special_keys,c.surl,c.campaignpackid,a.appkey,a.url as appurl,ch.name as channelname,ch.unique_name,ch.category from campaign c, app a, channel ch where c.awssuccess=false and a.id=c.app and ch.id=c.channel";
		Connection conn = dbUtil.getConn();
		Statement st = conn.createStatement();
		ResultSet rs = st.executeQuery(sql);
		List<Map<String, String>> list = new ArrayList<Map<String, String>>();
		while (rs.next()) {
			String channelcategory = rs.getString("category");

			String surl = rs.getString("surl");
			if (!StringUtil.isEmpty(channelcategory) && channelcategory.equals("APPMARKET")) {
				surl = rs.getString("appkey")+":"+rs.getString("campaignpackid");
			}
			Map<String, String> inner = new HashMap<String, String>();
			inner.put("surl", surl);
			inner.put("name", rs.getString("name"));
			inner.put("channelid", rs.getString("channelid"));
			String uniq = rs.getString("unique_name");
			inner.put("channelname", StringUtil.isEmpty(uniq) ? "" : uniq);
			inner.put("channel", rs.getString("channelname"));
			inner.put("cid", rs.getString("channel"));
			inner.put("appid", rs.getString("appkey"));
			String special = rs.getString("special_keys");
			if (!StringUtil.isEmpty(special)) {
				inner.put("specialkeys", special);
			}
			inner.put("category", channelcategory);
			String appurl = rs.getString("appurl");
			String url = rs.getString("url");
			inner.put("url", StringUtil.isEmpty(url) ? appurl : url);
			list.add(inner);
		}
		if (rs != null) {
			rs.close();
		}
		if (st != null) {
			rs.close();
		}
		if (conn != null) {
			conn.close();
		}
		return list;
	}


	public static void updateStatusInMysql(String surlstr) throws SQLException {
		DBUtil dbUtil = DBUtil.newInstance();
		String sql = "update campaign set awssuccess=true where surl in ("+surlstr+")";
		Connection conn = dbUtil.getConn();
		PreparedStatement pdst = conn.prepareStatement(sql);
		pdst.executeUpdate();
		pdst.close();
		conn.close();
	}

	public static void updateStatusInMysqlId(String idstr) throws SQLException {
		DBUtil dbUtil = DBUtil.newInstance();
		String sql = "update campaign set awssuccess=true where campaignpackid in ("+idstr+")";
		Connection conn = dbUtil.getConn();
		PreparedStatement pdst = conn.prepareStatement(sql);
		pdst.executeUpdate();
		pdst.close();
		conn.close();
	}


}
*/
