package com.reyun.repository;

import com.reyun.model.Event;
import com.reyun.model.EventAttributeMeta;
import com.reyun.model.EventMeta;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Transactional
public interface EventAttributeMetaRepository extends JpaRepository<EventAttributeMeta, Long> {

    List<EventAttributeMeta> findByAppkey(String appkey);

    @Query(value = "select * from event_attribute_meta where appkey = ?1 and attribute = ?2", nativeQuery = true)
    EventAttributeMeta findByAttribute(String appkey, String name);

    @Query(value = "select * from event_attribute_meta where `appkey`=?1 and (`alias`=?2 OR `attribute`=?2)", nativeQuery = true)
    EventAttributeMeta findByAliasOrName(String appkey, String name);

    @Query(value = "select * from event_attribute_meta where appkey = ?1 and status is true and (add_stats_condition is true or add_stats_view is true)", nativeQuery = true)
    List<EventAttributeMeta> findByAppkeyAndCondition(String appkey);

    @Query(value = "SELECT * FROM event_attribute_meta WHERE appKey=?2 AND attribute IN(?1)", nativeQuery = true)
    List<EventAttributeMeta> findAllByAttributeList(List<String> eventList, String appKey);
}
