package com.reyun.repository;

import com.reyun.model.IntelligentPath;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by sunhao on 17/7/18.
 * desc:只能路径DAO
 */
public interface IntelligentPathRepository extends JpaRepository<IntelligentPath, Long> {

    @Query(value = "select * from intelligent_path where app = ?1 and del_flag is not true order by modify_time desc ", nativeQuery = true)
    List<IntelligentPath> findActiveByApp(Long appId);

    @Query(value = "select * from intelligent_path where  app = ?1 and name = ?2 and create_account = ?3 and del_flag is not true ", nativeQuery = true)
    List<IntelligentPath> findByNameApp(Long appId, String name, Long accountId);

    @Modifying
    @Transactional
    @Query(value = "update intelligent_path set del_flag = true where id = ?1 and create_account = ?2 and del_flag is not true", nativeQuery = true)
    int deleteById(Long id, Long accountId);

}
