package com.reyun.service;

import com.reyun.model.Account;
import com.reyun.model.CustomMenu;
import com.reyun.model.CustomMenuShare;
import com.reyun.model.CustomMenuTemplate;
import com.reyun.util.ResultModel;

import java.util.List;
import java.util.Map;

/**
 * Created by sunhao on 17/4/21.
 * desc:
 */
public interface CustomMenuService {

    List<CustomMenuShare> listAllSharedMenuByCategory(Long accountId, Long appId);

    List<CustomMenu> listMyCustomMenu(Long accountId, Long appId);

    List<CustomMenuShare> listMyFavorite(Long accountId, Long appId);

    CustomMenu createMyMenu(Long accountId, Long appId, String name);

    CustomMenuTemplate addCustomMenuTemplate(Account account, Long appId, Long menuId, CustomMenuTemplate customMenuTemplate);

    boolean deleteMyMenu(Long accountId, Long appId, Long menuId);

    boolean deleteMyMenuTemplate(Long accountId, Long templateId);

    List<CustomMenuTemplate> addToMyMenu(Account account, Long appId, CustomMenuShare customMenuShare);

    boolean addToFavorite(Long accountId, Long appId, Long menuId);

    boolean deleteFavorite(Long accountId, Long appId, Long menuId);

    boolean validMyMenuNumber(Long accountId, Long appId);

    boolean validMyMenuName(Long appId, String menuName);

    boolean validIsExists(Long appId, Long shareId);

    ResultModel validMenuTemplate(Long accountId, Long menuId, Long templateId, String menuType);

    List<CustomMenuTemplate> addReyunToMyMenu(Account account, Long appId);

    boolean cancelShareMyMenu(Long accountId, Long appId, Long menuId);

    boolean findAllMenuAndFavorite(Long accountId, Long appId);

    boolean updateMyMenuName(Long accountId, Long menuId, String name);

    Map<String, List> queryAllReport(Long accountId, Long appId, Long reportId, String menuType, String startDate, String endDate, String viewFlag);

    List<CustomMenu> listMyMenuList(Long accountId, Long appId);

    CustomMenu getMyMenuDetail(Long menuId);

    int updateMenuAccountName(Long accountId, String accountName);

    boolean updateMyMenuIndex(Long accountId, Long appid, Long menuId, int index);

    boolean updateMyMenuTemplateIndex(Long accountId, Long id, int index);

    CustomMenuTemplate updateMyMenuTemplateType(Long accountId, Long id, String type);

    List<CustomMenu> listByReportId(Long originalReportId, String type);

    List<CustomMenuShare> findIndustry();

}
