package com.reyun.service;

import java.util.List;
import java.util.Map;

import com.reyun.model.Account;
import com.reyun.model.Funnel;


public interface FunnelService {
	
	Funnel create(Funnel funnel, Long account);
	
	Funnel update(Funnel funnel, Long account);
	
	Funnel delete(Long id, Long account);
	
	Funnel findById(Long id);
	
	List<Funnel> findByApp(Long app);
	
	Funnel validName(String name, Long app);
	
	Map<String, List> funnelReport(Long funnel, String startDate, String endDate, String usergroup, boolean isList, String dimention, Account account, boolean isDevice, boolean isProfile);

    Map<String, List> funnelDataQuery(String startDate, String endDate, String eventInfo, String events, int window,
                                      Long appId, boolean isDevice);
}
