package com.reyun.service.impl;


import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.reyun.model.CommonEvent;
import com.reyun.repository.CommonEventRepository;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.reyun.model.CommonParam;

import com.reyun.repository.CommonParamRepository;
import com.reyun.service.CommonParamService;
import org.springframework.util.StringUtils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service
public class CommonParamServiceImpl implements CommonParamService {

	@Autowired
	CommonParamRepository commonParamRepository;
    @Autowired
    CommonEventRepository commonEventRepository;


	@Override
	public Map<String, CommonParam> findAllByType(String type) {
		List<CommonParam> commonParamList = commonParamRepository.findAllByType(type);
		Map<String, CommonParam> result = new HashMap<>();
		for (CommonParam commonparam : commonParamList) {
			result.put(commonparam.getParam(), commonparam);
		}
		return result;
	}

    @Override
    public Map<String, CommonEvent> findAllCommonEvent() {

        List<CommonEvent> commonEventList = commonEventRepository.findAll();

        return Maps.uniqueIndex(commonEventList,new Function<CommonEvent,String>(){
            @Override
            public String apply(CommonEvent commonEvent) {
                return commonEvent.getEvent();
            }
        });
    }

    @Override
    public List<CommonParam> listAllByType(String type) {

        return StringUtils.isEmpty(type) ? commonParamRepository.findAllCommonParam() : commonParamRepository.findAllByType(type);
    }


}
