package com.reyun.service.impl;

import com.google.common.collect.Lists;
import com.reyun.dic.ConfigEnumType;
import com.reyun.model.ConfigParam;
import com.reyun.repository.ConfigParamRepository;
import com.reyun.service.ConfigParamService;
import com.reyun.util.StringUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

/**
 * Created by sunhao on 17/3/3.
 *
 * 所有的KEY值都需要在ConfigEnumType中定义
 */
@Service
public class ConfigParamServiceImpl implements ConfigParamService{

    @Autowired
    ConfigParamRepository configParamRepository;


    @Override
    public List<ConfigParam> getConfigParamByKeys(String... keys) {

        List<String> keyList = Lists.newArrayList(keys);

        return  configParamRepository.findParamsByKeys(keyList);
    }

    @Override
    public String generateMasterPwd() {

        String masterPwdPrefix = configParamRepository.findParamsByKey(ConfigEnumType.MASTER_PWD_PREFIX.getKey());

        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");

        return StringUtil.isEmpty(masterPwdPrefix)?null:masterPwdPrefix + "_" + dateFormat.format(new Date());
    }

    @Override
    public String getConfigParamByKey(String key) {
        return configParamRepository.findParamsByKey(key);
    }
}
