(function(){
	// 所有表单List以及验证方法
	var optionTxt = {
		isNull:"必填",
		errorLetter:"含特殊字符或过长",
		errorLength:"40字符以内",
		errorFormat:"格式不对",
		lowLetter:"输入小写字母",
		errorEmail:"请输入48位以内的正确邮箱",
		errorNum:"输入数字",
		errorPwd:"仅支持数字，大小写字母，且至少包含其中2种，长度限制为6-18位",
		errorQQ :"请输入正确QQ号码",
		errorCrm :"两次密码不一致，请重新输入",
		errorCompany :"公司名称，支持48位内汉字或96位内字母数字",
		errorUsername :"您的姓名，支持16位内汉字或32位内字母数字",
		errorWechat :"6-20位数字，字母，下划线或中划线，须以数字或字母开头",
		errorUrl:"以http://或https://开头的合法url",
		errorName:"名称不合法或过长"
	};
	var fn=function(option){
		if(!option.val){
			return option.nullTxt || "必填";
		}
		var str=option.val.replace(/[^\x00-\xff]/g, '00');
		if((option.min && str.length<option.min) || (option.max && str.length>option.max)){
			return option.regTxt
		}else if(option.regFlag && option.reg.test(option.val)){
			return option.regTxt
		}else if(!option.regFlag && option.reg && !option.reg.test(option.val)){
			return option.regTxt
		}else{
			return "succ"
		}
	},
	obj={
		isNull:function(option){
			var options={
				val:option.val,
				name:option.txt || optionTxt.isNull
			}
			return fn(options)
		},
		nameLen:function(option){
			var options={
				val:option.val,
				max:option.max || 40,
				min:option.min || 2,
				regTxt:option.txt || optionTxt.errorLength
			}
			return fn(options)
		},
		isMaxLen:function(option){
			var options={
				val:option.val,
				max:option.max || 40,
				min:option.min || 2,
				regTxt:option.txt
			}
			return fn(options);
		},
		name:function(option){
			var options={
				val:option.val,
				max:option.max || 40,
				min:option.min || 2,
				reg:/[`~!@#\$%\^\&\*\(\)\+<>\?:"\{\},\.\\\/;'\[\]]/im,
				regFlag:true,
				regTxt:option.txt || optionTxt.errorLetter
			}
			return fn(options)
		},
		nameFormat:function(option){
			var options={
				val:option.val,
				max:option.max || 40,
				min:option.min || 1,
				reg:/^[!"#$%&'()*+,-./:;<=>?@[\]^_`{|}~\\！（\）《》？：·“ ”，。、；`‘’【】——……￥「」／a-zA-Z0-9\u4E00-\u9FA5]+$/,
				regFlag:false,
				regTxt:option.txt || optionTxt.errorName
			}
			return fn(options)
		},
		spcname:function(option){
			var options={
				val:option.val,
				max:option.max || 40,
				min:option.min || 1,
				reg:/^[a-zA-Z0-9_\-\u4E00-\u9FA5]+$/,
				regFlag:false,
				regTxt:option.txt || optionTxt.errorLetter
			}
			return fn(options)
		},
		spcname1:function(option){
			var options={
				val:option.val,
				max:option.max || 40,
				min:option.min || 1,
				reg:/^[a-zA-Z0-9_\-\·\u4E00-\u9FA5]+$/,
				regFlag:false,
				regTxt:option.txt || optionTxt.errorLetter
			}
			return fn(options)
		},
		spcname2:function(option){
			var options={
				val:option.val,
				max:option.max || 40,
				min:option.min || 1,
				reg:/^[a-zA-Z0-9_\u4E00-\u9FA5]+$/,
				regFlag:false,
				regTxt:option.txt || optionTxt.errorLetter
			}
			return fn(options)
		},
		keyword:function(option){
			var options={
				val:option.val,
				max:option.max || 40,
				min:option.min || 1,
				reg:/^[a-zA-Z0-9\.\-\u4E00-\u9FA5]+$/,
				regFlag:false,
				regTxt:option.txt || optionTxt.errorLetter
			}
			return fn(options)
		},
		companyname:function(option){
			var options={
				val:option.val,
				max:option.max || 96,
				reg:/^[a-zA-Z0-9_\s\-\u4E00-\u9FA5\(\)\（\）]+$/,
				regFlag:false,
				regTxt:option.txt || optionTxt.errorCompany
			}
			return fn(options)
		},
		username:function(option){
			var options={
				val:option.val,
				max:option.max || 32,
				reg:/^[a-zA-Z0-9_\-\u4E00-\u9FA5]+$/,
				regFlag:false,
				regTxt:option.txt || optionTxt.errorUsername
			}
			return fn(options)
		},
		numLetter:function(option){
			var options={
				val:option.val,
				max:option.max || 32,
				reg:/^[a-zA-Z0-9\u4E00-\u9FA5]+$/,
				regFlag:false,
				regTxt:option.txt || optionTxt.errorUsername,
				nullTxt:option.nullTxt
			}
			return fn(options)
		},
		onelink:function(option){
			var options={
				val:option.val,
				max:option.max || 40,
				reg:/^[a-zA-Z0-9_\_\-\u4E00-\u9FA5]+$/,
				regFlag:false,
				regTxt:option.txt || optionTxt.errorUsername
			}
			return fn(options)
		},
		wechat:function(option){
			var options={
				val:option.val,
				reg:/^[a-zA-Z0-9]{1}[a-zA-Z\d_\d-]{5,19}$/,
				regFlag:false,
				regTxt:option.txt || optionTxt.errorWechat,
				nullTxt:option.nullTxt
			}
			return fn(options)
		},
		email:function(option){
			var options={
				val:option.val,
				max:option.max || 48,
                reg: /^([a-zA-Z0-9]+[_|\_|\.|\-]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[_|\_|\.|\-]?)*[a-zA-Z0-9]+\.[a-zA-Z]{1,63}$/,
				regFlag:false,
				regTxt:option.txt || optionTxt.errorEmail,
				nullTxt:option.nullTxt
			}
			return fn(options)
		},
		url:function(option){
			var options={
				val:option.val,
                reg: /(http|https):\/\/[^\s]+/,
				regFlag:false,
				regTxt:option.txt || optionTxt.errorUrl,
                nullTxt:option.nullTxt
            }
			return fn(options)
		},
		num:function(option){
			var options={
				val:option.val,
				reg:/\D/g,
				max:option.max || 64,
				min:option.min || 1,
				regFlag:true,
				regTxt:option.txt || optionTxt.errorNum,
				nullTxt:option.nullTxt
			}
			return fn(options)
		},
		qq:function(option){
			var options={
				val:option.val,
				reg:/\D/g,
				max:option.max || 12,
				min:option.min || 6,
				regFlag:true,
				regTxt:option.txt || optionTxt.errorQQ
			}
			return fn(options)
		},
		numFloat:function(option){
			var options={
				val:option.val,
				reg: /^\d+(\.\d{1,2})?$/,
				regFlag:false,
				regTxt:option.txt || optionTxt.errorFormat
			}
			return fn(options)
		},
		isLowLetter:function(option){
			var options={
				val:option.val,
				reg: /^[a-z]+$/,
				regFlag:false,
				regTxt:option.txt || optionTxt.lowLetter
			}
			return fn(options);
		},
		pwd:function(option){
			var options={
				val:option.val,
				// min:6,
				// max:18,
				reg:/^(?![0-9]+$)(?![a-z]+$)(?![A-Z]+$)(?![\-_]+$)[0-9A-Za-z]{6,18}$/,
				regFlag:false,
				regTxt:option.txt || optionTxt.errorPwd
			}
			return fn(options);
		},
		cellphone: function(option){
			var options = {
				val : option.val,
				reg:/^((\d{3,4}-\d{7,14}))|(^1(3|4|5|7|8)\d{9})$/,
				regFlag:false,
				regTxt:option.txt || "号码有误"
			}
			return fn(options);
		},
		ipError:function(option){
			var options = {
				val : option.val,
				reg:/^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$/,
				regFlag:false,
				regTxt:option.txt || "支持数字和“.”"
			}
			return fn(options);
		}
	}
	// 表单验证方法
	return formJudge=function(par){
		var infoArr=[],infoObj={};
		for(x in par){
			var option=par[x];
				info=obj[par[x].key](option),
				status=false;
				if(info!="succ"){
					infoArr.push(info)
					status=true

					infoObj[x]={
						status:status,
						txt:info
					}
				}
		}
		if(infoArr.length>0){
			infoObj.succ=false;
			for(i in infoObj){
				if(infoObj[i].txt != "succ"){
					infoObj[i].status = true;
				}

				if(infoObj[i].status=="true"){
					document.getElementById(i).focus();
					var top=document.getElementById(i).offsetTop
					document.documentElement.scrollTop=top-70;
					break
				}
			}
		}else{
			infoObj={
				succ:true
			}
		}
		return infoObj
	}
})();
