(function(){
    angular.module("app.manage")
        .controller("eventCtrl",["$scope","HttpService","ToolService",eventCtrl]);

    function eventCtrl($scope,HttpService,ToolService){
        $scope.isevent = true;
    	$scope.query = function(){
            $scope.isevent = true;
    		var eventPM = HttpService.getInfo("mng/event/find/"+$scope.appid);
            ToolService.showLoading();
            eventPM.then(function(data){
                ToolService.hideLoading();
                $scope.eventList = data;

                var seldatas = data.slice(0);
                seldatas.unshift({eventName:"-all",eventNameAlias:"全部属性"});
                $scope.eventSelList = seldatas;
                $scope.eventEditId = -1;
            });
    	}
    	$scope.$watch("appid",function(n){
    		if(angular.isDefined(n)){
    			$scope.query();
    		}
    	});

        $scope.$on('flipinfo',function(e,msg){
            if(msg.listkey == 'paramTab'){
                $scope.pflipPage = msg;
            }else{
                $scope.flipPage = msg;
            }
            
        });

        var curEvent = null,rmd = 1;
        $scope.clickEvent = function(event){
            if($scope.eventpidInit == event.eventName){
                $scope.isevent = false;
                $scope.eventpidF5 = ++rmd;
            }else{
                $scope.eventpidInit = event.eventName;
            }
        }

        $scope.$on("eventpid",function(e,msg){
            curEvent = msg.info;
            $scope.getParamsList();
        });
        $scope.getParamsList = function(){
            var pams = {};
            if(curEvent!=null && curEvent.eventName && curEvent.eventName!='-all'){
                pams = {name:curEvent.eventName};
            }
            var paramsPM = HttpService.getInfo("mng/event/find/one/"+$scope.appid,pams);
            ToolService.showLoading();
            paramsPM.then(function(data){
                $scope.isevent = false;
                ToolService.hideLoading();
                $scope.paramsList = data;
                $scope.eventParamsId = -1;
            });
        }

        $scope.doEdit = function(obj,flag){
            if(flag==1){
                $scope.eventEditId=obj.eventName;
                obj.editname=obj.eventNameAlias;
            }
            if(flag==2){
                $scope.eventParamsId=obj.attr;
                obj.editname=obj.attrAlias;
            }
        }
        //启用停用
        $scope.onOff = function(name,flag){
        	var url = "mng/event/enable/"+$scope.appid,tipmsg = "启用成功";
        	if(flag && flag==1){
        		url = "mng/event/forbidden/"+$scope.appid;
                tipmsg = "停用成功";
        	}
        	var userPM = HttpService.putInfo(url,{eventId:name});
            ToolService.showLoading();
	    	userPM.then(function(data){
                ToolService.hideLoading();
	    		ToolService.showTips(tipmsg)
                $scope.query();
	    	});
        }
        //事件更新
        $scope.updateEvent = function(info){
            var params = {
                eventId:info.eventName,
                alias:info.editname
            }
            if(info.editname==''){
                ToolService.showTips("事件名称不能为空")
                return false;
            }
            var has = $scope.eventList.filter(function(item){
                return item.eventNameAlias == info.editname && item.eventName!=info.eventName;
            });
            if(has.length>0){
                ToolService.showTips("事件名称不能重复")
                return false;
            }

            var tips = formJudge({
                name:{
                    key:'spcname2',
                    val:params.alias
                }
            });
            if(tips.succ != true){
                ToolService.showTips("仅支持包含下划线的40位以内字符");
                return false;
            }
            var updatePM = HttpService.putInfo("mng/event/update/"+$scope.appid,params);
            ToolService.showLoading();
            updatePM.then(function(data){
                ToolService.hideLoading();
                ToolService.showTips("修改成功")
                $scope.query();
            });
        }
        
        //属性启用停用
        $scope.pramesOnOff = function(info,flag){
            var url = "mng/event/enable/attr/"+$scope.appid,tipmsg = "启用成功";
            if(flag && flag==1){
                url = "mng/event/forbidden/attr/"+$scope.appid;
                tipmsg = "停用成功"
            }
            var userPM = HttpService.putInfo(url,{attribute:info});
            ToolService.showLoading();
            userPM.then(function(data){
                ToolService.hideLoading();
                ToolService.showTips(tipmsg)
                $scope.getParamsList();
            });
        }
        //属性更新
        $scope.updateParams = function(info){
            var params = {
                attribute:info.attr,
                alias:info.editname
            }
            if(info.editname==''){
                ToolService.showTips("属性名称不能为空")
                return false;
            }
            var has = $scope.paramsList.filter(function(item){
                return item.attrAlias == info.editname && item.attr!=info.attr;
            });
            if(has.length>0){
                ToolService.showTips("事件属性名称不能重复")
                return false;
            }

            var tips = formJudge({
                name:{
                    key:'spcname2',
                    val:params.alias
                }
            });
            if(tips.succ != true){
                ToolService.showTips("仅支持包含下划线的40位以内字符");
                return false;
            }
            
            var updatePM = HttpService.putInfo("mng/event/update/"+$scope.appid+"/one",params);
            ToolService.showLoading();
            updatePM.then(function(data){
                ToolService.hideLoading();
                ToolService.showTips("修改成功")
                $scope.getParamsList();
            });
        }

        $scope.changeStatus = function(flag,attr){
            var method = "";
            switch (flag) {
                case 1:
                    method = "addStats";
                    break;
                case 2:
                    method = "delStats";
                    break;
                case 3:
                    method = "addCondition";
                    break;
                case 4:
                    method = "delCondition";
                    break;
                default:
                    break;
            }
            if(method!=''){
                var putPM = HttpService.putInfo("mng/event/"+method+"/"+$scope.appid,{attribute:attr})
                putPM.then(function(data){
                    if(!localStorage.getItem("joinFiltrate") && flag==3){
                        ToolService.showTips("操作成功,可以按属性名称在事件、漏斗或留存功能中查看或筛选",4000);
                        localStorage.setItem("joinFiltrate","joinFiltrate");
                    }else{
                        ToolService.showTips("操作成功");
                    }   
                    $scope.getParamsList();
                });
            }
        }
    }
 
})();