/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.config.app;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.configuration.app.entity.AppConfig;
import com.dianping.cat.configuration.app.entity.Code;
import com.dianping.cat.configuration.app.entity.Command;
import com.dianping.cat.configuration.app.entity.ConfigItem;
import com.dianping.cat.configuration.app.entity.Item;
import com.dianping.cat.configuration.app.transform.DefaultSaxParser;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.util.StringUtils;
import org.unidal.tuple.Pair;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppConfigManager
implements Initializable {
    @Inject
    protected ConfigDao m_configDao;
    @Inject
    private ContentFetcher m_fetcher;
    private volatile Map<String, Command> m_commands = new ConcurrentHashMap<String, Command>();
    private volatile Map<String, Integer> m_cities = new ConcurrentHashMap<String, Integer>();
    private volatile Map<String, Integer> m_operators = new ConcurrentHashMap<String, Integer>();
    private volatile Map<Integer, String> m_excludedCommands = new ConcurrentHashMap<Integer, String>();
    private int m_configId;
    private volatile AppConfig m_config;
    private long m_modifyTime;
    private static final String CONFIG_NAME = "app-config";
    public static final String NETWORK = "\u7f51\u7edc\u7c7b\u578b";
    public static final String OPERATOR = "\u8fd0\u8425\u5546";
    public static final String VERSION = "\u7248\u672c";
    public static final String PLATFORM = "\u5e73\u53f0";
    public static final String CITY = "\u57ce\u5e02";
    public static final String CONNECT_TYPE = "\u8fde\u63a5\u7c7b\u578b";
    public static final int TOO_LONG_COMMAND_ID = 23;
    public static final int ALL_COMMAND_ID = 0;
    public static final int COMMAND_ID = 1200;

    public Pair<Boolean, Integer> addCommand(Command command) throws Exception {
        int commandId = 0;
        commandId = this.findAvailableId(1, 1200);
        command.setId(commandId);
        this.m_config.addCommand(command);
        return new Pair((Object)this.storeConfig(), (Object)commandId);
    }

    public boolean addConstant(String type, int id, String value) {
        ConfigItem item = this.m_config.getConfigItems().get(type);
        if (item != null) {
            Item data = item.getItems().get(id);
            if (data != null) {
                data.setName(value);
            } else {
                data = new Item(id);
                data.setName(value);
                item.getItems().put(id, data);
            }
            return true;
        }
        return false;
    }

    private Map<String, List<Command>> buildSortedCommands(Map<String, List<Command>> commands) {
        LinkedHashMap<String, List<Command>> results = new LinkedHashMap<String, List<Command>>();
        ArrayList<String> domains = new ArrayList<String>(commands.keySet());
        Collections.sort(domains);
        CommandComparator comparator = new CommandComparator();
        for (String domain : domains) {
            List<Command> cmds = commands.get(domain);
            Collections.sort(cmds, comparator);
            results.put(domain, cmds);
        }
        return results;
    }

    public boolean containCommand(int id) {
        Set<Integer> keys = this.m_config.getCommands().keySet();
        return keys.contains(id);
    }

    private AppConfig copyAppConfig() throws SAXException, IOException {
        String xml = this.m_config.toString();
        AppConfig config = DefaultSaxParser.parse(xml);
        return config;
    }

    public boolean deleteCode(int id, int codeId) {
        Command command = this.m_config.getCommands().get(id);
        if (command != null) {
            command.getCodes().remove(codeId);
        }
        return this.storeConfig();
    }

    public boolean deleteCommand(int id) {
        this.m_config.removeCommand(id);
        return this.storeConfig();
    }

    public Pair<Boolean, List<Integer>> deleteCommand(String domain, String name) {
        Collection<Command> commands = this.m_config.getCommands().values();
        ArrayList<Integer> needDeleteIds = new ArrayList<Integer>();
        for (Command command : commands) {
            if (!name.equals(command.getName()) || domain != null && (domain == null || !domain.equals(command.getDomain()))) continue;
            needDeleteIds.add(command.getId());
        }
        Iterator<Command> iterator = needDeleteIds.iterator();
        while (iterator.hasNext()) {
            int id = (Integer)((Object)iterator.next());
            this.m_config.removeCommand(id);
        }
        return new Pair((Object)this.storeConfig(), needDeleteIds);
    }

    public int findAvailableId(int start, int end) throws Exception {
        ArrayList<Integer> keys = new ArrayList<Integer>(this.m_config.getCommands().keySet());
        Collections.sort(keys);
        ArrayList<Integer> tmp = new ArrayList<Integer>();
        for (int i = 0; i < keys.size(); ++i) {
            int value = (Integer)keys.get(i);
            if (value < start || value > end) continue;
            tmp.add(value);
        }
        int size = tmp.size();
        if (size == 0) {
            return start;
        }
        if (size == 1) {
            return (Integer)tmp.get(0) + 1;
        }
        if (size == end - start + 1) {
            RuntimeException ex = new RuntimeException();
            Cat.logError((String)("app config range is full: " + start + " - " + end), (Throwable)ex);
            throw ex;
        }
        int key = (Integer)tmp.get(0);
        int last = key;
        for (int i = 0; i < size; ++i) {
            key = (Integer)tmp.get(i);
            if (key - last > 1) {
                return last + 1;
            }
            last = key;
        }
        return last + 1;
    }

    public Map<String, Integer> getCities() {
        return this.m_cities;
    }

    public Map<Integer, Code> getCodes() {
        return this.m_config.getCodes();
    }

    public Map<String, Command> getCommands() {
        return this.m_commands;
    }

    public AppConfig getConfig() {
        return this.m_config;
    }

    public Map<Integer, String> getExcludedCommands() {
        return this.m_excludedCommands;
    }

    public Map<String, Integer> getOperators() {
        return this.m_operators;
    }

    public Map<Integer, Command> getRawCommands() {
        return this.m_config.getCommands();
    }

    public void initialize() {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_config = DefaultSaxParser.parse(content);
            this.m_modifyTime = config.getModifyDate().getTime();
            this.refreshData();
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_config = DefaultSaxParser.parse(content);
                this.refreshData();
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_config == null) {
            this.m_config = new AppConfig();
        }
    }

    public boolean insert(String xml) {
        try {
            this.m_config = DefaultSaxParser.parse(xml);
            return this.storeConfig();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    public boolean isNameDuplicate(String name) {
        for (Command command : this.m_config.getCommands().values()) {
            if (!command.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean isSuccessCode(int commandId, int code) {
        Map<Integer, Code> codes = this.queryCodeByCommand(commandId);
        for (Code c : codes.values()) {
            if (c.getId() != code) continue;
            return c.getStatus() == 0;
        }
        return false;
    }

    public Map<Integer, Code> queryCodeByCommand(int command) {
        Command c = this.m_config.findCommand(command);
        HashMap<Integer, Code> result = new HashMap<Integer, Code>();
        if (c != null) {
            Map<Integer, Code> values = c.getCodes();
            result.putAll(this.m_config.getCodes());
            result.putAll(values);
        }
        return result;
    }

    public Map<Integer, List<Code>> queryCommand2Codes() {
        LinkedHashMap<Integer, List<Code>> codes = new LinkedHashMap<Integer, List<Code>>();
        for (Command command : this.queryCommands()) {
            ArrayList<Code> items = (ArrayList<Code>)codes.get(command.getId());
            if (items == null) {
                items = new ArrayList<Code>();
                codes.put(command.getId(), items);
            }
            items.addAll(command.getCodes().values());
        }
        return codes;
    }

    public List<Command> queryCommands() {
        ArrayList<Command> results = new ArrayList<Command>();
        try {
            AppConfig config = this.copyAppConfig();
            Map<Integer, Command> commands = config.getCommands();
            for (Map.Entry<Integer, Command> entry : commands.entrySet()) {
                Map<Integer, Code> codes = entry.getValue().getCodes();
                for (Map.Entry<Integer, Code> e : this.m_config.getCodes().entrySet()) {
                    if (codes.containsKey(e.getKey())) continue;
                    codes.put(e.getKey(), e.getValue());
                }
            }
            results = new ArrayList<Command>(commands.values());
            Collections.sort(results, new CommandComparator());
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        return results;
    }

    public Map<Integer, Item> queryConfigItem(String name) {
        ConfigItem config = this.m_config.findConfigItem(name);
        if (config != null) {
            return config.getItems();
        }
        return new ConcurrentHashMap<Integer, Item>();
    }

    public Map<String, List<Command>> queryDomain2Commands() {
        return this.queryDomain2Commands(this.queryCommands());
    }

    public Map<String, List<Command>> queryDomain2Commands(List<Command> commands) {
        LinkedHashMap<String, List<Command>> map = new LinkedHashMap<String, List<Command>>();
        for (Command command : commands) {
            ArrayList<Command> cmds;
            String domain = command.getDomain();
            if (StringUtils.isEmpty((String)domain)) {
                domain = "default";
            }
            if ((cmds = (ArrayList<Command>)map.get(domain)) == null) {
                cmds = new ArrayList<Command>();
                map.put(domain, cmds);
            }
            cmds.add(command);
        }
        return this.buildSortedCommands(map);
    }

    public Map<Integer, Code> queryInternalCodes(int commandId) {
        Command cmd = this.m_config.getCommands().get(commandId);
        if (cmd != null) {
            return cmd.getCodes();
        }
        return new HashMap<Integer, Code>();
    }

    public Item queryItem(String type, int id) {
        ConfigItem itemConfig = this.m_config.getConfigItems().get(type);
        if (itemConfig != null) {
            Item item = itemConfig.getItems().get(id);
            return item;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAppConfig() throws DalException, SAXException, IOException {
        Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
        long modifyTime = config.getModifyDate().getTime();
        AppConfigManager appConfigManager = this;
        synchronized (appConfigManager) {
            if (modifyTime > this.m_modifyTime) {
                AppConfig appConfig;
                String content = config.getContent();
                this.m_config = appConfig = DefaultSaxParser.parse(content);
                this.m_modifyTime = modifyTime;
                this.refreshData();
            }
        }
    }

    private void refreshData() {
        ConcurrentHashMap<Integer, String> excludedCommands = new ConcurrentHashMap<Integer, String>();
        Collection<Command> commands = this.m_config.getCommands().values();
        ConcurrentHashMap<String, Command> commandMap = new ConcurrentHashMap<String, Command>();
        for (Command c : commands) {
            commandMap.put(c.getName(), c);
            if (c.isAll()) continue;
            excludedCommands.put(c.getId(), c.getName());
        }
        this.m_commands = commandMap;
        this.m_excludedCommands = excludedCommands;
        ConcurrentHashMap<String, Integer> cityMap = new ConcurrentHashMap<String, Integer>();
        ConfigItem cities = this.m_config.findConfigItem(CITY);
        if (cities != null && cities.getItems() != null) {
            for (Item item : cities.getItems().values()) {
                cityMap.put(item.getName(), item.getId());
            }
        }
        this.m_cities = cityMap;
        ConcurrentHashMap<String, Integer> operatorMap = new ConcurrentHashMap<String, Integer>();
        ConfigItem operations = this.m_config.findConfigItem(OPERATOR);
        for (Item item : operations.getItems().values()) {
            operatorMap.put(item.getName(), item.getId());
        }
        this.m_operators = operatorMap;
    }

    public boolean shouldAdd2AllCommands(int id) {
        return !this.m_excludedCommands.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sortCommands() {
        Map<Integer, Command> commands = this.m_config.getCommands();
        LinkedHashMap<Integer, Command> results = new LinkedHashMap<Integer, Command>();
        ArrayList<Integer> ids = new ArrayList<Integer>(commands.keySet());
        Collections.sort(ids);
        for (int i = 0; i < ids.size(); ++i) {
            int id = (Integer)ids.get(i);
            results.put(id, commands.get(id));
        }
        AppConfigManager appConfigManager = this;
        synchronized (appConfigManager) {
            commands.clear();
            commands.putAll(results);
        }
    }

    public boolean storeConfig() {
        try {
            Config config = this.m_configDao.createLocal();
            config.setId(this.m_configId);
            config.setKeyId(this.m_configId);
            config.setName(CONFIG_NAME);
            config.setContent(this.m_config.toString());
            this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
            this.sortCommands();
            this.refreshData();
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
        return true;
    }

    public boolean updateCode(Code code) {
        this.m_config.getCodes().put(code.getId(), code);
        return true;
    }

    public boolean updateCode(int id, Code code) {
        Command command = this.m_config.findCommand(id);
        if (command != null) {
            command.getCodes().put(code.getId(), code);
            return this.storeConfig();
        }
        return false;
    }

    public boolean updateCommand(int id, Command command) {
        Command c = this.m_config.findCommand(id);
        c.setDomain(command.getDomain());
        c.setName(command.getName());
        c.setTitle(command.getTitle());
        c.setAll(command.getAll());
        c.setThreshold(command.getThreshold());
        return this.storeConfig();
    }

    public class ConfigReloadTask
    implements Threads.Task {
        public String getName() {
            return "App-Config-Reload";
        }

        public void run() {
            boolean active = true;
            while (active) {
                try {
                    AppConfigManager.this.refreshAppConfig();
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    active = false;
                }
            }
        }

        public void shutdown() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CommandComparator
    implements Comparator<Command> {
        @Override
        public int compare(Command o1, Command o2) {
            String c1 = o1.getName();
            String title1 = o1.getTitle();
            String c2 = o2.getName();
            String title2 = o2.getTitle();
            if (StringUtils.isNotEmpty((String)title1)) {
                c1 = title1;
            }
            if (StringUtils.isNotEmpty((String)title2)) {
                c2 = title2;
            }
            return c1.compareTo(c2);
        }
    }
}

