/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.config.web.js;

import com.dianping.cat.Cat;
import com.dianping.cat.config.content.ContentFetcher;
import com.dianping.cat.config.web.js.AggregationHandler;
import com.dianping.cat.configuration.web.js.entity.Aggregation;
import com.dianping.cat.configuration.web.js.entity.AggregationRule;
import com.dianping.cat.configuration.web.js.transform.DefaultSaxParser;
import com.dianping.cat.core.config.Config;
import com.dianping.cat.core.config.ConfigDao;
import com.dianping.cat.core.config.ConfigEntity;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.unidal.dal.jdbc.DalException;
import org.unidal.dal.jdbc.DalNotFoundException;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggregationConfigManager
implements Initializable {
    @Inject
    protected ConfigDao m_configDao;
    @Inject
    protected AggregationHandler m_handler;
    @Inject
    private ContentFetcher m_fetcher;
    private int m_configId;
    private static final String CONFIG_NAME = "aggreationConfig";
    private volatile Aggregation m_aggregation;
    private long m_modifyTime;
    public static final int PROBLEM_TYPE = 3;

    public boolean deleteAggregationRule(String rule) {
        this.m_aggregation.removeAggregationRule(rule);
        this.m_handler.register(this.queryAggregationRules());
        return this.storeConfig();
    }

    public String handle(int type, String domain, String status) {
        return this.m_handler.handle(type, domain, status);
    }

    public void initialize() {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            this.m_configId = config.getId();
            this.m_aggregation = DefaultSaxParser.parse(content);
            this.m_modifyTime = config.getModifyDate().getTime();
        }
        catch (DalNotFoundException e) {
            try {
                String content = this.m_fetcher.getConfigContent(CONFIG_NAME);
                Config config = this.m_configDao.createLocal();
                config.setName(CONFIG_NAME);
                config.setContent(content);
                this.m_configDao.insert(config);
                this.m_configId = config.getId();
                this.m_aggregation = DefaultSaxParser.parse(content);
            }
            catch (Exception ex) {
                Cat.logError((Throwable)ex);
            }
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
        }
        if (this.m_aggregation == null) {
            this.m_aggregation = new Aggregation();
        }
        this.m_handler.register(this.queryAggregationRules());
        Threads.forGroup((String)"cat").start((Runnable)((Object)new ConfigReloadTask()));
    }

    public boolean insertAggregationRule(AggregationRule rule) {
        this.m_aggregation.addAggregationRule(rule);
        this.m_handler.register(this.queryAggregationRules());
        return this.storeConfig();
    }

    public List<AggregationRule> queryAggrarationRulesFromDB() {
        try {
            this.m_aggregation = this.queryAggreation();
            return new ArrayList<AggregationRule>(this.m_aggregation.getAggregationRules().values());
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return new ArrayList<AggregationRule>();
        }
    }

    public AggregationRule queryAggration(String key) {
        return this.m_aggregation.findAggregationRule(key);
    }

    private Aggregation queryAggreation() {
        try {
            Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
            String content = config.getContent();
            return DefaultSaxParser.parse(content);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return new Aggregation();
        }
    }

    public List<AggregationRule> queryAggregationRules() {
        return new ArrayList<AggregationRule>(this.m_aggregation.getAggregationRules().values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshAggreationConfig() throws DalException, SAXException, IOException {
        Config config = this.m_configDao.findByName(CONFIG_NAME, ConfigEntity.READSET_FULL);
        long modifyTime = config.getModifyDate().getTime();
        AggregationConfigManager aggregationConfigManager = this;
        synchronized (aggregationConfigManager) {
            if (modifyTime > this.m_modifyTime) {
                Aggregation aggregation;
                String content = config.getContent();
                this.m_aggregation = aggregation = DefaultSaxParser.parse(content);
                this.m_handler.register(this.queryAggregationRules());
                this.m_modifyTime = modifyTime;
            }
        }
    }

    public void refreshRule() {
        List<AggregationRule> rules = this.queryAggrarationRulesFromDB();
        this.m_handler.register(rules);
    }

    private boolean storeConfig() {
        try {
            Config config = this.m_configDao.createLocal();
            config.setId(this.m_configId);
            config.setKeyId(this.m_configId);
            config.setName(CONFIG_NAME);
            config.setContent(this.m_aggregation.toString());
            this.m_configDao.updateByPK(config, ConfigEntity.UPDATESET_FULL);
        }
        catch (Exception e) {
            Cat.logError((Throwable)e);
            return false;
        }
        return true;
    }

    public class ConfigReloadTask
    implements Threads.Task {
        public String getName() {
            return "Aggreation-Config-Reload";
        }

        public void run() {
            boolean active = true;
            while (active) {
                try {
                    AggregationConfigManager.this.refreshAggreationConfig();
                }
                catch (Exception e) {
                    Cat.logError((Throwable)e);
                }
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    active = false;
                }
            }
        }

        public void shutdown() {
        }
    }
}

