/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.app.command.entity;

import com.dianping.cat.configuration.app.command.BaseEntity;
import com.dianping.cat.configuration.app.command.IVisitor;
import com.dianping.cat.configuration.app.command.entity.Rule;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandFormat
extends BaseEntity<CommandFormat> {
    private List<Rule> m_rules = new ArrayList<Rule>();
    private int m_picSmall = 1000;
    private int m_picMiddel = 2000;
    private int m_picLarge = 4000;

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitCommandFormat(this);
    }

    public CommandFormat addRule(Rule rule) {
        this.m_rules.add(rule);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CommandFormat) {
            CommandFormat _o = (CommandFormat)obj;
            if (!this.equals(this.getRules(), _o.getRules())) {
                return false;
            }
            if (this.getPicSmall() != _o.getPicSmall()) {
                return false;
            }
            if (this.getPicMiddel() != _o.getPicMiddel()) {
                return false;
            }
            return this.getPicLarge() == _o.getPicLarge();
        }
        return false;
    }

    public int getPicLarge() {
        return this.m_picLarge;
    }

    public int getPicMiddel() {
        return this.m_picMiddel;
    }

    public int getPicSmall() {
        return this.m_picSmall;
    }

    public List<Rule> getRules() {
        return this.m_rules;
    }

    public int hashCode() {
        int hash = 0;
        for (Rule e : this.m_rules) {
            hash = hash * 31 + (e == null ? 0 : e.hashCode());
        }
        hash = hash * 31 + this.m_picSmall;
        hash = hash * 31 + this.m_picMiddel;
        hash = hash * 31 + this.m_picLarge;
        return hash;
    }

    @Override
    public void mergeAttributes(CommandFormat other) {
        this.m_picSmall = other.getPicSmall();
        this.m_picMiddel = other.getPicMiddel();
        this.m_picLarge = other.getPicLarge();
    }

    public CommandFormat setPicLarge(int picLarge) {
        this.m_picLarge = picLarge;
        return this;
    }

    public CommandFormat setPicMiddel(int picMiddel) {
        this.m_picMiddel = picMiddel;
        return this;
    }

    public CommandFormat setPicSmall(int picSmall) {
        this.m_picSmall = picSmall;
        return this;
    }
}

