/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.app.entity;

import com.dianping.cat.configuration.app.BaseEntity;
import com.dianping.cat.configuration.app.IVisitor;
import com.dianping.cat.configuration.app.entity.Code;
import com.dianping.cat.configuration.app.entity.Command;
import com.dianping.cat.configuration.app.entity.ConfigItem;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppConfig
extends BaseEntity<AppConfig> {
    private Map<String, ConfigItem> m_configItems = new LinkedHashMap<String, ConfigItem>();
    private Map<Integer, Code> m_codes = new LinkedHashMap<Integer, Code>();
    private Map<Integer, Command> m_commands = new LinkedHashMap<Integer, Command>();

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitAppConfig(this);
    }

    public AppConfig addCode(Code code) {
        this.m_codes.put(code.getId(), code);
        return this;
    }

    public AppConfig addCommand(Command command) {
        this.m_commands.put(command.getId(), command);
        return this;
    }

    public AppConfig addConfigItem(ConfigItem configItem) {
        this.m_configItems.put(configItem.getId(), configItem);
        return this;
    }

    public boolean equals(Object obj) {
        if (obj instanceof AppConfig) {
            AppConfig _o = (AppConfig)obj;
            if (!this.equals(this.getConfigItems(), _o.getConfigItems())) {
                return false;
            }
            if (!this.equals(this.getCodes(), _o.getCodes())) {
                return false;
            }
            return this.equals(this.getCommands(), _o.getCommands());
        }
        return false;
    }

    public Code findCode(Integer id) {
        return this.m_codes.get(id);
    }

    public Command findCommand(Integer id) {
        return this.m_commands.get(id);
    }

    public ConfigItem findConfigItem(String id) {
        return this.m_configItems.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Code findOrCreateCode(Integer id) {
        Code code = this.m_codes.get(id);
        if (code == null) {
            Map<Integer, Code> map = this.m_codes;
            synchronized (map) {
                code = this.m_codes.get(id);
                if (code == null) {
                    code = new Code(id);
                    this.m_codes.put(id, code);
                }
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Command findOrCreateCommand(Integer id) {
        Command command = this.m_commands.get(id);
        if (command == null) {
            Map<Integer, Command> map = this.m_commands;
            synchronized (map) {
                command = this.m_commands.get(id);
                if (command == null) {
                    command = new Command(id);
                    this.m_commands.put(id, command);
                }
            }
        }
        return command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigItem findOrCreateConfigItem(String id) {
        ConfigItem configItem = this.m_configItems.get(id);
        if (configItem == null) {
            Map<String, ConfigItem> map = this.m_configItems;
            synchronized (map) {
                configItem = this.m_configItems.get(id);
                if (configItem == null) {
                    configItem = new ConfigItem(id);
                    this.m_configItems.put(id, configItem);
                }
            }
        }
        return configItem;
    }

    public Map<Integer, Code> getCodes() {
        return this.m_codes;
    }

    public Map<Integer, Command> getCommands() {
        return this.m_commands;
    }

    public Map<String, ConfigItem> getConfigItems() {
        return this.m_configItems;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_configItems == null ? 0 : this.m_configItems.hashCode());
        hash = hash * 31 + (this.m_codes == null ? 0 : this.m_codes.hashCode());
        hash = hash * 31 + (this.m_commands == null ? 0 : this.m_commands.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(AppConfig other) {
    }

    public Code removeCode(Integer id) {
        return this.m_codes.remove(id);
    }

    public Command removeCommand(Integer id) {
        return this.m_commands.remove(id);
    }

    public ConfigItem removeConfigItem(String id) {
        return this.m_configItems.remove(id);
    }
}

