/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.server.entity;

import com.dianping.cat.configuration.server.BaseEntity;
import com.dianping.cat.configuration.server.IVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HdfsConfig
extends BaseEntity<HdfsConfig> {
    private String m_id;
    private String m_maxSize = "128M";
    private String m_serverUri;
    private String m_baseDir;

    public HdfsConfig() {
    }

    public HdfsConfig(String id) {
        this.m_id = id;
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitHdfs(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof HdfsConfig) {
            HdfsConfig _o = (HdfsConfig)obj;
            return this.equals(this.getId(), _o.getId());
        }
        return false;
    }

    public String getBaseDir() {
        return this.m_baseDir;
    }

    public String getId() {
        return this.m_id;
    }

    public String getMaxSize() {
        return this.m_maxSize;
    }

    public String getServerUri() {
        return this.m_serverUri;
    }

    public int hashCode() {
        int hash = 0;
        hash = hash * 31 + (this.m_id == null ? 0 : this.m_id.hashCode());
        return hash;
    }

    @Override
    public void mergeAttributes(HdfsConfig other) {
        this.assertAttributeEquals(other, "hdfs", "id", this.m_id, other.getId());
        if (other.getMaxSize() != null) {
            this.m_maxSize = other.getMaxSize();
        }
        if (other.getServerUri() != null) {
            this.m_serverUri = other.getServerUri();
        }
        if (other.getBaseDir() != null) {
            this.m_baseDir = other.getBaseDir();
        }
    }

    public HdfsConfig setBaseDir(String baseDir) {
        this.m_baseDir = baseDir;
        return this;
    }

    public HdfsConfig setId(String id) {
        this.m_id = id;
        return this;
    }

    public HdfsConfig setMaxSize(String maxSize) {
        this.m_maxSize = maxSize;
        return this;
    }

    public HdfsConfig setServerUri(String serverUri) {
        this.m_serverUri = serverUri;
        return this;
    }
}

