/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.server.filter.transform;

import com.dianping.cat.configuration.server.filter.IVisitor;
import com.dianping.cat.configuration.server.filter.entity.CrashLogDomain;
import com.dianping.cat.configuration.server.filter.entity.ServerFilterConfig;
import java.util.Stack;

public class DefaultValidator
implements IVisitor {
    private Path m_path = new Path();

    protected void assertRequired(String name, Object value) {
        if (value == null) {
            throw new RuntimeException(String.format("%s at path(%s) is required!", name, this.m_path));
        }
    }

    public void visitCrashLogDomain(CrashLogDomain crashLogDomain) {
        this.m_path.down("crash-log-domain");
        this.assertRequired("id", crashLogDomain.getId());
        this.m_path.up("crash-log-domain");
    }

    public void visitServerFilterConfig(ServerFilterConfig serverFilterConfig) {
        this.m_path.down("server-filter-config");
        this.visitServerFilterConfigChildren(serverFilterConfig);
        this.m_path.up("server-filter-config");
    }

    protected void visitServerFilterConfigChildren(ServerFilterConfig serverFilterConfig) {
        for (CrashLogDomain crashLogDomain : serverFilterConfig.getCrashLogDomains().values()) {
            this.visitCrashLogDomain(crashLogDomain);
        }
    }

    static class Path {
        private Stack<String> m_sections = new Stack();

        Path() {
        }

        public Path down(String nextSection) {
            this.m_sections.push(nextSection);
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (String section : this.m_sections) {
                sb.append('/').append(section);
            }
            return sb.toString();
        }

        public Path up(String currentSection) {
            if (this.m_sections.isEmpty() || !this.m_sections.peek().equals(currentSection)) {
                throw new RuntimeException("INTERNAL ERROR: stack mismatched!");
            }
            this.m_sections.pop();
            return this;
        }
    }
}

