/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.web.url.transform;

import com.dianping.cat.configuration.web.url.IEntity;
import com.dianping.cat.configuration.web.url.entity.Code;
import com.dianping.cat.configuration.web.url.entity.PatternItem;
import com.dianping.cat.configuration.web.url.entity.UrlPattern;
import com.dianping.cat.configuration.web.url.transform.DefaultLinker;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultJsonParser {
    private DefaultLinker m_linker = new DefaultLinker(true);
    private Stack<String> m_tags = new Stack();
    private Stack<Object> m_objs = new Stack();
    private List<Object> m_entities = new ArrayList<Object>();
    private Class<?> m_entityClass;

    private DefaultJsonParser(Class<?> entityClass) {
        this.m_entityClass = entityClass;
    }

    public static <T extends IEntity<T>> T parse(Class<T> entityClass, InputStream in) throws IOException {
        return DefaultJsonParser.parse(entityClass, new InputStreamReader(in, "utf-8"));
    }

    public static <T extends IEntity<T>> T parse(Class<T> entityClass, Reader reader) throws IOException {
        DefaultJsonParser parser = new DefaultJsonParser(entityClass);
        parser.onArrayBegin();
        parser.parse(new JsonReader(reader));
        parser.onArrayEnd();
        if (parser.m_entities.isEmpty()) {
            return null;
        }
        return (T)((IEntity)parser.m_entities.get(0));
    }

    public static <T extends IEntity<T>> T parse(Class<T> entityClass, String json) throws IOException {
        return DefaultJsonParser.parse(entityClass, new StringReader(json));
    }

    public static <T extends IEntity<T>> List<T> parseArray(Class<T> entityClass, InputStream in) throws Exception {
        return DefaultJsonParser.parseArray(entityClass, new InputStreamReader(in, "utf-8"));
    }

    public static <T extends IEntity<T>> List<T> parseArray(Class<T> entityClass, Reader reader) throws Exception {
        DefaultJsonParser parser = new DefaultJsonParser(entityClass);
        parser.parse(new JsonReader(reader));
        return parser.m_entities;
    }

    public static <T extends IEntity<T>> List<T> parseArray(Class<T> entityClass, String json) throws Exception {
        return DefaultJsonParser.parseArray(entityClass, new StringReader(json));
    }

    protected <T> T convert(Class<T> type, String value, T defaultValue) {
        if (value == null || value.length() == 0) {
            return defaultValue;
        }
        if (type == Boolean.class) {
            return (T)Boolean.valueOf(value);
        }
        if (type == Integer.class) {
            return (T)Integer.valueOf(value);
        }
        if (type == Long.class) {
            return (T)Long.valueOf(value);
        }
        if (type == Short.class) {
            return (T)Short.valueOf(value);
        }
        if (type == Float.class) {
            return (T)Float.valueOf(value);
        }
        if (type == Double.class) {
            return (T)Double.valueOf(value);
        }
        if (type == Byte.class) {
            return (T)Byte.valueOf(value);
        }
        if (type == Character.class) {
            return (T)Character.valueOf(value.charAt(0));
        }
        return (T)value;
    }

    private Object createRootEntity() {
        try {
            Object entity = this.m_entityClass.newInstance();
            return entity;
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Unable to create entity(%s) instance!", this.m_entityClass.getName()), e);
        }
    }

    private boolean isTopLevel() {
        return this.m_objs.size() == 1;
    }

    protected void onArrayBegin() {
        if (this.m_objs.isEmpty()) {
            this.m_objs.push(this.m_entities);
            this.m_tags.push("");
        }
    }

    protected void onArrayEnd() {
        this.m_objs.pop();
        this.m_tags.pop();
    }

    protected void onName(String name) {
        this.m_tags.push(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void onObjectBegin() {
        if (this.isTopLevel()) {
            this.m_objs.push(this.createRootEntity());
            this.m_tags.push("");
            return;
        } else {
            Object parent = this.m_objs.peek();
            String tag = this.m_tags.peek();
            if (!(parent instanceof UrlPattern)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
            if ("pattern-items".equals(tag) || "codes".equals(tag)) {
                this.m_objs.push(parent);
                return;
            } else {
                String parentTag;
                String string = parentTag = this.m_tags.size() >= 2 ? (String)this.m_tags.get(this.m_tags.size() - 2) : null;
                if ("pattern-items".equals(parentTag)) {
                    PatternItem patternItems = new PatternItem();
                    this.m_linker.onPatternItem((UrlPattern)parent, patternItems);
                    this.m_objs.push(patternItems);
                    return;
                } else {
                    if (!"codes".equals(parentTag)) throw new RuntimeException(String.format("Unknown tag(%s) found at %s!", tag, this.m_tags));
                    Code codes = new Code();
                    this.m_linker.onCode((UrlPattern)parent, codes);
                    this.m_objs.push(codes);
                }
            }
        }
    }

    protected void onObjectEnd() {
        this.m_tags.pop();
        Object entity = this.m_objs.pop();
        if (this.isTopLevel()) {
            this.m_entities.add(entity);
        }
    }

    protected void onValue(String value) {
        Object parent = this.m_objs.peek();
        String tag = this.m_tags.pop();
        if (parent instanceof UrlPattern) {
            this.parseForUrlPattern((UrlPattern)parent, tag, value);
        } else if (parent instanceof PatternItem) {
            this.parseForPatternItem((PatternItem)parent, tag, value);
        } else if (parent instanceof Code) {
            this.parseForCode((Code)parent, tag, value);
        } else {
            throw new RuntimeException(String.format("Unknown tag(%s) under %s!", tag, parent));
        }
    }

    private void parse(JsonReader reader) throws IOException {
        block2: {
            try {
                reader.parse(this);
            }
            catch (EOFException e) {
                if (this.m_objs.size() <= 1) break block2;
                throw new EOFException(String.format("Unexpected end while parsing json! tags: %s.", this.m_tags));
            }
        }
        this.m_linker.finish();
    }

    public void parseForCode(Code code, String tag, String value) {
        if ("id".equals(tag)) {
            code.setId(this.convert(Integer.class, value, null));
        } else if ("name".equals(tag)) {
            code.setName(value);
        } else if ("status".equals(tag)) {
            code.setStatus(this.convert(Integer.class, value, null));
        } else {
            throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, code, this.m_tags));
        }
    }

    public void parseForPatternItem(PatternItem patternItem, String tag, String value) {
        if ("group".equals(tag)) {
            patternItem.setGroup(value);
        } else if ("name".equals(tag)) {
            patternItem.setName(value);
        } else if ("pattern".equals(tag)) {
            patternItem.setPattern(value);
        } else if ("domain".equals(tag)) {
            patternItem.setDomain(value);
        } else if ("id".equals(tag)) {
            patternItem.setId(this.convert(Integer.class, value, 0));
        } else {
            throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, patternItem, this.m_tags));
        }
    }

    public void parseForUrlPattern(UrlPattern urlPattern, String tag, String value) {
        if (!"pattern-items".equals(tag) && !"codes".equals(tag)) {
            throw new RuntimeException(String.format("Unknown tag(%s) of %s under %s!", tag, urlPattern, this.m_tags));
        }
    }

    static class JsonReader {
        private Reader m_reader;
        private char[] m_buffer = new char[2048];
        private int m_size;
        private int m_index;

        public JsonReader(Reader reader) {
            this.m_reader = reader;
        }

        private char next() throws IOException {
            if (this.m_index >= this.m_size) {
                this.m_size = this.m_reader.read(this.m_buffer);
                this.m_index = 0;
                if (this.m_size == -1) {
                    throw new EOFException();
                }
            }
            return this.m_buffer[this.m_index++];
        }

        public void parse(DefaultJsonParser parser) throws IOException {
            StringBuilder sb = new StringBuilder();
            boolean flag = false;
            block15: while (true) {
                char ch = this.next();
                switch (ch) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': {
                        continue block15;
                    }
                    case '{': {
                        parser.onObjectBegin();
                        flag = false;
                        continue block15;
                    }
                    case '}': {
                        if (flag) {
                            parser.onValue(sb.toString());
                            sb.setLength(0);
                        }
                        parser.onObjectEnd();
                        flag = false;
                        continue block15;
                    }
                    case '\"': 
                    case '\'': {
                        char ch2;
                        while ((ch2 = this.next()) != ch) {
                            if (ch2 == '\\') {
                                char ch3 = this.next();
                                switch (ch3) {
                                    case 't': {
                                        sb.append('\t');
                                        break;
                                    }
                                    case 'r': {
                                        sb.append('\r');
                                        break;
                                    }
                                    case 'n': {
                                        sb.append('\n');
                                        break;
                                    }
                                    default: {
                                        sb.append(ch3);
                                        break;
                                    }
                                }
                                continue;
                            }
                            sb.append(ch2);
                        }
                        if (!flag) {
                            parser.onName(sb.toString());
                        } else {
                            parser.onValue(sb.toString());
                            flag = false;
                        }
                        sb.setLength(0);
                        continue block15;
                    }
                    case ':': {
                        if (sb.length() != 0) {
                            parser.onName(sb.toString());
                            sb.setLength(0);
                        }
                        flag = true;
                        continue block15;
                    }
                    case ',': {
                        if (sb.length() != 0) {
                            if (!flag) {
                                parser.onName(sb.toString());
                            } else {
                                parser.onValue(sb.toString());
                            }
                            sb.setLength(0);
                        }
                        flag = false;
                        continue block15;
                    }
                    case '[': {
                        parser.onArrayBegin();
                        flag = false;
                        continue block15;
                    }
                    case ']': {
                        parser.onArrayEnd();
                        flag = false;
                        continue block15;
                    }
                }
                sb.append(ch);
            }
        }
    }
}

