/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration.web.url.transform;

import com.dianping.cat.configuration.web.url.entity.Code;
import com.dianping.cat.configuration.web.url.entity.PatternItem;
import com.dianping.cat.configuration.web.url.entity.UrlPattern;
import com.dianping.cat.configuration.web.url.transform.ILinker;
import java.util.ArrayList;
import java.util.List;

public class DefaultLinker
implements ILinker {
    private boolean m_deferrable;
    private List<Runnable> m_deferedJobs = new ArrayList<Runnable>();

    public DefaultLinker(boolean deferrable) {
        this.m_deferrable = deferrable;
    }

    public void finish() {
        for (Runnable job : this.m_deferedJobs) {
            job.run();
        }
    }

    public boolean onCode(final UrlPattern parent, final Code code) {
        if (this.m_deferrable) {
            this.m_deferedJobs.add(new Runnable(){

                public void run() {
                    parent.addCode(code);
                }
            });
        } else {
            parent.addCode(code);
        }
        return true;
    }

    public boolean onPatternItem(final UrlPattern parent, final PatternItem patternItem) {
        if (this.m_deferrable) {
            this.m_deferedJobs.add(new Runnable(){

                public void run() {
                    parent.addPatternItem(patternItem);
                }
            });
        } else {
            parent.addPatternItem(patternItem);
        }
        return true;
    }
}

