/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.helper;

import java.util.Calendar;
import java.util.Date;

public class TimeHelper {
    public static final long ONE_SECOND = 1000L;
    public static final long ONE_MINUTE = 60000L;
    public static final long ONE_HOUR = 3600000L;
    public static final long ONE_DAY = 86400000L;
    public static final long ONE_WEEK = 604800000L;

    public static Date addDays(Date date, int day) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, day);
        return cal.getTime();
    }

    public static Date getCurrentDay() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getCurrentDay(int index) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, index);
        return cal.getTime();
    }

    public static Date getCurrentDay(long timestamp) {
        return TimeHelper.getCurrentDay(timestamp, 0);
    }

    public static Date getCurrentDay(long timestamp, int index) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(timestamp);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, index);
        return cal.getTime();
    }

    public static Date getCurrentHour() {
        Calendar cal = Calendar.getInstance();
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getCurrentHour(int index) {
        Calendar cal = Calendar.getInstance();
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(11, index);
        return cal.getTime();
    }

    public static Date getCurrentMinute() {
        Calendar cal = Calendar.getInstance();
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getCurrentMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getCurrentWeek() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        int dayOfWeek = cal.get(7);
        if (dayOfWeek == 7) {
            return cal.getTime();
        }
        cal.add(5, -dayOfWeek);
        return cal.getTime();
    }

    public static Date getLastMonth() {
        Calendar cal = Calendar.getInstance();
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(2, -1);
        return cal.getTime();
    }

    public static String getMinuteStr() {
        int minute = Calendar.getInstance().get(12);
        String minuteStr = String.valueOf(minute);
        if (minute < 10) {
            minuteStr = '0' + minuteStr;
        }
        return "M" + minuteStr;
    }

    public static Date getYesterday() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.add(5, -1);
        return cal.getTime();
    }

    public static boolean sleepToNextMinute() {
        try {
            long current = System.currentTimeMillis();
            Thread.sleep(60000L - current % 60000L + 500L);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }
}

