/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.codec;

import com.dianping.cat.message.spi.codec.BufferWriter;
import io.netty.buffer.ByteBuf;

public class HtmlEncodingBufferWriter
implements BufferWriter {
    public static final String ID = "html";
    private static byte[] AMP = "&amp;".getBytes();
    private static byte[] LT = "&lt;".getBytes();
    private static byte[] GT = "&gt;".getBytes();
    private static byte[] BR = "<br>".getBytes();

    public int writeTo(ByteBuf buffer, byte[] data) {
        int len;
        int count = len = data.length;
        int offset = 0;
        for (int i = 0; i < len; ++i) {
            byte b = data[i];
            if (b == 38) {
                buffer.writeBytes(data, offset, i - offset);
                buffer.writeBytes(AMP);
                count += AMP.length - 1;
                offset = i + 1;
                continue;
            }
            if (b == 60) {
                buffer.writeBytes(data, offset, i - offset);
                buffer.writeBytes(LT);
                count += LT.length - 1;
                offset = i + 1;
                continue;
            }
            if (b == 62) {
                buffer.writeBytes(data, offset, i - offset);
                buffer.writeBytes(GT);
                count += GT.length - 1;
                offset = i + 1;
                continue;
            }
            if (b != 10) continue;
            buffer.writeBytes(data, offset, i - offset + 1);
            buffer.writeBytes(BR);
            count += BR.length;
            offset = i + 1;
        }
        buffer.writeBytes(data, offset, len - offset);
        return count;
    }
}

