/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.storage;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.GZIPInputStream;

public class MessageBlockReader {
    private RandomAccessFile m_indexFile;
    private RandomAccessFile m_dataFile;

    public MessageBlockReader(File dataFile) throws IOException {
        File indexFile = new File(dataFile.getAbsolutePath() + ".idx");
        this.m_indexFile = new RandomAccessFile(indexFile, "r");
        this.m_dataFile = new RandomAccessFile(dataFile, "r");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RandomAccessFile randomAccessFile = this.m_indexFile;
        synchronized (randomAccessFile) {
            this.m_indexFile.close();
            this.m_dataFile.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readMessage(int index) throws IOException {
        int blockAddress = 0;
        int blockOffset = 0;
        this.m_indexFile.seek((long)index * 6L);
        blockAddress = this.m_indexFile.readInt();
        blockOffset = this.m_indexFile.readShort() & 0xFFFF;
        this.m_dataFile.seek(blockAddress);
        byte[] buf = new byte[this.m_dataFile.readInt()];
        this.m_dataFile.readFully(buf);
        ByteArrayInputStream bais = new ByteArrayInputStream(buf);
        DataInputStream in = new DataInputStream(new GZIPInputStream(bais));
        try {
            in.skip(blockOffset);
            int len = in.readInt();
            byte[] data = new byte[len];
            in.readFully(data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
    }
}

