/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.report.service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ModelPeriod {
    CURRENT,
    HISTORICAL,
    LAST;


    public static ModelPeriod getByName(String name, ModelPeriod defaultValue) {
        for (ModelPeriod period : ModelPeriod.values()) {
            if (!period.name().equals(name)) continue;
            return period;
        }
        return defaultValue;
    }

    public static ModelPeriod getByTime(long timestamp) {
        long current = System.currentTimeMillis();
        if (timestamp >= (current -= current % 3600000L)) {
            return CURRENT;
        }
        if (timestamp >= current - 3600000L) {
            return LAST;
        }
        return HISTORICAL;
    }

    public long getStartTime() {
        long current = System.currentTimeMillis();
        current -= current % 3600000L;
        switch (this) {
            case CURRENT: {
                return current;
            }
            case LAST: {
                return current - 3600000L;
            }
        }
        return current;
    }

    public boolean isCurrent() {
        return this == CURRENT;
    }

    public boolean isHistorical() {
        return this == HISTORICAL;
    }

    public boolean isLast() {
        return this == LAST;
    }
}

