/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.task;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.core.dal.Task;
import com.dianping.cat.core.dal.TaskDao;
import java.util.Calendar;
import java.util.Date;
import org.unidal.dal.jdbc.DalException;
import org.unidal.lookup.annotation.Inject;

public class TaskManager {
    @Inject
    private TaskDao m_taskDao;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static final int STATUS_TODO = 1;
    public static final int REPORT_HOUR = 0;
    public static final int REPORT_DAILY = 1;
    public static final int REPORT_WEEK = 2;
    public static final int REPORT_MONTH = 3;

    private void createDailyTask(Date period, String domain, String name) throws DalException {
        this.createTask(period, domain, name, 1);
    }

    private void createHourlyTask(Date period, String domain, String name) throws DalException {
        this.createTask(period, domain, name, 0);
    }

    private void createMonthlyTask(Date period, String domain, String name) throws DalException {
        this.createTask(period, domain, name, 3);
    }

    protected void createTask(Date period, String domain, String name, int reportType) throws DalException {
        Task task = this.m_taskDao.createLocal();
        task.setCreationDate(new Date());
        task.setProducer(NetworkInterfaceManager.INSTANCE.getLocalHostAddress());
        task.setReportDomain(domain);
        task.setReportName(name);
        task.setReportPeriod(period);
        task.setStatus(1);
        task.setTaskType(reportType);
        this.m_taskDao.insert(task);
    }

    public boolean createTask(Date period, String domain, String name, TaskCreationPolicy prolicy) {
        try {
            int dayOfMonth;
            int dayOfWeek;
            if (prolicy.shouldCreateHourlyTask()) {
                this.createHourlyTask(period, domain, name);
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(period);
            int hour = cal.get(11);
            cal.add(11, -hour);
            Date currentDay = cal.getTime();
            if (prolicy.shouldCreateDailyTask()) {
                this.createDailyTask(new Date(currentDay.getTime() - 86400000L), domain, name);
            }
            if (prolicy.shouldCreateWeeklyTask() && (dayOfWeek = cal.get(7)) == 7) {
                this.createWeeklyTask(new Date(currentDay.getTime() - 604800000L), domain, name);
            }
            if (prolicy.shouldCreateMonthTask() && (dayOfMonth = cal.get(5)) == 1) {
                cal.add(2, -1);
                this.createMonthlyTask(cal.getTime(), domain, name);
            }
            return true;
        }
        catch (DalException e) {
            Cat.logError((Throwable)e);
            return false;
        }
    }

    private void createWeeklyTask(Date period, String domain, String name) throws DalException {
        this.createTask(period, domain, name, 2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TaskProlicy implements TaskCreationPolicy
    {
        ALL{

            public boolean shouldCreateDailyTask() {
                return true;
            }

            public boolean shouldCreateHourlyTask() {
                return true;
            }

            public boolean shouldCreateMonthTask() {
                return true;
            }

            public boolean shouldCreateWeeklyTask() {
                return true;
            }
        }
        ,
        HOULY{

            public boolean shouldCreateDailyTask() {
                return false;
            }

            public boolean shouldCreateHourlyTask() {
                return true;
            }

            public boolean shouldCreateMonthTask() {
                return false;
            }

            public boolean shouldCreateWeeklyTask() {
                return false;
            }
        }
        ,
        ALL_EXCLUED_HOURLY{

            public boolean shouldCreateDailyTask() {
                return true;
            }

            public boolean shouldCreateHourlyTask() {
                return false;
            }

            public boolean shouldCreateMonthTask() {
                return true;
            }

            public boolean shouldCreateWeeklyTask() {
                return true;
            }
        }
        ,
        DAILY{

            public boolean shouldCreateDailyTask() {
                return true;
            }

            public boolean shouldCreateHourlyTask() {
                return false;
            }

            public boolean shouldCreateMonthTask() {
                return false;
            }

            public boolean shouldCreateWeeklyTask() {
                return false;
            }
        }
        ,
        HOURLY_AND_DAILY{

            public boolean shouldCreateDailyTask() {
                return true;
            }

            public boolean shouldCreateHourlyTask() {
                return true;
            }

            public boolean shouldCreateMonthTask() {
                return false;
            }

            public boolean shouldCreateWeeklyTask() {
                return false;
            }
        };

    }

    public static interface TaskCreationPolicy {
        public boolean shouldCreateHourlyTask();

        public boolean shouldCreateDailyTask();

        public boolean shouldCreateWeeklyTask();

        public boolean shouldCreateMonthTask();
    }
}

