/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration;

import com.dianping.cat.configuration.client.BaseEntity;
import com.dianping.cat.configuration.client.entity.ClientConfig;
import com.dianping.cat.configuration.client.entity.Domain;
import com.dianping.cat.configuration.client.entity.Property;
import com.dianping.cat.configuration.client.transform.DefaultMerger;
import java.util.Stack;

public class ClientConfigMerger
extends DefaultMerger {
    public ClientConfigMerger(ClientConfig config) {
        super(config);
    }

    protected void mergeDomain(Domain old, Domain domain) {
        if (domain.getIp() != null) {
            old.setIp(domain.getIp());
        }
        if (domain.getEnabled() != null) {
            old.setEnabled(domain.getEnabled());
        }
        if (domain.getMaxMessageSize() > 0) {
            old.setMaxMessageSize(domain.getMaxMessageSize());
        }
    }

    protected void visitConfigChildren(ClientConfig to, ClientConfig from) {
        if (to != null) {
            BaseEntity target;
            Stack<Object> objs = this.getObjects();
            if (!from.getServers().isEmpty()) {
                to.getServers().clear();
                to.getServers().addAll(from.getServers());
            }
            for (Domain domain : from.getDomains().values()) {
                target = to.findDomain(domain.getId());
                if (target == null) {
                    target = new Domain(domain.getId());
                    to.addDomain((Domain)target);
                }
                if (!to.getDomains().containsKey(domain.getId())) continue;
                objs.push(target);
                domain.accept(this);
                objs.pop();
            }
            for (Property property : from.getProperties().values()) {
                target = to.findProperty(property.getName());
                if (target == null) {
                    target = new Property(property.getName());
                    to.addProperty((Property)target);
                }
                objs.push(target);
                property.accept(this);
                objs.pop();
            }
        }
    }
}

