/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.message.io;

import com.dianping.cat.configuration.ClientConfigManager;
import com.dianping.cat.configuration.client.entity.Server;
import com.dianping.cat.message.io.MessageSender;
import com.dianping.cat.message.io.TcpSocketSender;
import com.dianping.cat.message.io.TransportManager;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;
import org.unidal.lookup.logging.LogEnabled;
import org.unidal.lookup.logging.Logger;

public class DefaultTransportManager
implements TransportManager,
Initializable,
LogEnabled {
    @Inject
    private ClientConfigManager m_configManager;
    @Inject
    private TcpSocketSender m_tcpSocketSender;
    private Logger m_logger;

    public void enableLogging(Logger logger) {
        this.m_logger = logger;
    }

    public MessageSender getSender() {
        return this.m_tcpSocketSender;
    }

    public void initialize() throws InitializationException {
        List<Server> servers = this.m_configManager.getServers();
        if (!this.m_configManager.isCatEnabled()) {
            this.m_tcpSocketSender = null;
            this.m_logger.warn("CAT was DISABLED due to not initialized yet!");
        } else {
            ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
            for (Server server : servers) {
                if (!server.isEnabled()) continue;
                addresses.add(new InetSocketAddress(server.getIp(), (int)server.getPort()));
            }
            this.m_logger.info("Remote CAT servers: " + addresses);
            if (addresses.isEmpty()) {
                throw new RuntimeException("All servers in configuration are disabled!\r\n" + servers);
            }
            this.m_tcpSocketSender.setServerAddresses(addresses);
            this.m_tcpSocketSender.initialize();
        }
    }
}

