/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.status;

import com.dianping.cat.Cat;
import com.dianping.cat.configuration.ClientConfigManager;
import com.dianping.cat.configuration.NetworkInterfaceManager;
import com.dianping.cat.message.Heartbeat;
import com.dianping.cat.message.MessageProducer;
import com.dianping.cat.message.Transaction;
import com.dianping.cat.message.internal.MilliSecondTimer;
import com.dianping.cat.message.spi.MessageStatistics;
import com.dianping.cat.status.StatusExtension;
import com.dianping.cat.status.StatusExtensionRegister;
import com.dianping.cat.status.StatusInfoCollector;
import com.dianping.cat.status.model.entity.Extension;
import com.dianping.cat.status.model.entity.StatusInfo;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.unidal.helper.Threads;
import org.unidal.lookup.annotation.Inject;
import org.unidal.lookup.extension.Initializable;
import org.unidal.lookup.extension.InitializationException;

public class StatusUpdateTask
implements Threads.Task,
Initializable {
    @Inject
    private MessageStatistics m_statistics;
    @Inject
    private ClientConfigManager m_manager;
    private boolean m_active = true;
    private String m_ipAddress;
    private long m_interval = 60000L;
    private String m_jars;

    private void buildClasspath() {
        ClassLoader loader = StatusUpdateTask.class.getClassLoader();
        StringBuilder sb = new StringBuilder();
        this.buildClasspath(loader, sb);
        if (sb.length() > 0) {
            this.m_jars = sb.substring(0, sb.length() - 1);
        }
    }

    private void buildClasspath(ClassLoader loader, StringBuilder sb) {
        if (loader instanceof URLClassLoader) {
            URL[] urLs;
            for (URL url : urLs = ((URLClassLoader)loader).getURLs()) {
                String jar = this.parseJar(url.toExternalForm());
                if (jar == null) continue;
                sb.append(jar).append(',');
            }
            ClassLoader parent = loader.getParent();
            this.buildClasspath(parent, sb);
        }
    }

    private void buildExtensionData(StatusInfo status) {
        StatusExtensionRegister res = StatusExtensionRegister.getInstance();
        List<StatusExtension> extensions = res.getStatusExtension();
        for (StatusExtension extension : extensions) {
            String id = extension.getId();
            String des = extension.getDescription();
            Map<String, String> propertis = extension.getProperties();
            Extension item = status.findOrCreateExtension(id).setDescription(des);
            for (Map.Entry<String, String> entry : propertis.entrySet()) {
                try {
                    double value = Double.parseDouble(entry.getValue());
                    item.findOrCreateExtensionDetail(entry.getKey()).setValue(value);
                }
                catch (Exception e) {
                    Cat.logError("StatusExtension can only be double type", e);
                }
            }
        }
    }

    public String getName() {
        return "StatusUpdateTask";
    }

    public void initialize() throws InitializationException {
        this.m_ipAddress = NetworkInterfaceManager.INSTANCE.getLocalHostAddress();
    }

    private String parseJar(String path) {
        int index;
        if (path.endsWith(".jar") && (index = path.lastIndexOf(47)) > -1) {
            return path.substring(index + 1);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Calendar cal;
        int second;
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            return;
        }
        while ((second = (cal = Calendar.getInstance()).get(13)) < 2 || second > 58) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            this.buildClasspath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MessageProducer cat = Cat.getProducer();
        Transaction reboot = cat.newTransaction("System", "Reboot");
        reboot.setStatus("0");
        cat.logEvent("Reboot", NetworkInterfaceManager.INSTANCE.getLocalHostAddress(), "0", null);
        reboot.complete();
        while (this.m_active) {
            long elapsed;
            long start = MilliSecondTimer.currentTimeMillis();
            if (this.m_manager.isCatEnabled()) {
                Transaction t = cat.newTransaction("System", "Status");
                Heartbeat h = cat.newHeartbeat("Heartbeat", this.m_ipAddress);
                StatusInfo status = new StatusInfo();
                t.addData("dumpLocked", this.m_manager.isDumpLocked());
                try {
                    StatusInfoCollector statusInfoCollector = new StatusInfoCollector(this.m_statistics, this.m_jars);
                    status.accept(statusInfoCollector.setDumpLocked(this.m_manager.isDumpLocked()));
                    this.buildExtensionData(status);
                    h.addData(status.toString());
                    h.setStatus("0");
                }
                catch (Throwable e) {
                    h.setStatus(e);
                    cat.logError(e);
                }
                finally {
                    h.complete();
                }
                t.setStatus("0");
                t.complete();
            }
            if ((elapsed = MilliSecondTimer.currentTimeMillis() - start) >= this.m_interval) continue;
            try {
                Thread.sleep(this.m_interval - elapsed);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    public void setInterval(long interval) {
        this.m_interval = interval;
    }

    public void shutdown() {
        this.m_active = false;
    }
}

