/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.converter.basic;

import java.lang.reflect.Type;
import org.unidal.converter.Converter;
import org.unidal.converter.ConverterException;
import org.unidal.converter.TypeUtil;

public class FloatConverter
implements Converter<Float> {
    @Override
    public boolean canConvert(Type fromType, Type targetType) {
        return TypeUtil.isTypeSupported(fromType, new Type[]{Number.class, Boolean.TYPE, Boolean.class, String.class, Enum.class});
    }

    @Override
    public Float convert(Object from, Type targetType) throws ConverterException {
        if (from instanceof Number) {
            return Float.valueOf(((Number)from).floatValue());
        }
        if (from instanceof Boolean) {
            return Float.valueOf((Boolean)from != false ? Float.valueOf(1.0f).floatValue() : 0.0f);
        }
        if (from instanceof Enum) {
            return Float.valueOf(((Enum)from).ordinal());
        }
        try {
            return Float.valueOf(from.toString());
        }
        catch (NumberFormatException e) {
            throw new ConverterException(e);
        }
    }

    @Override
    public Type getTargetType() {
        return Float.class;
    }
}

