/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.helper;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.unidal.helper.Files;
import org.unidal.helper.Splitters;

public class Scanners {
    public static DirScanner forDir() {
        return DirScanner.INSTANCE;
    }

    public static JarScanner forJar() {
        return JarScanner.INSTANCE;
    }

    public static ResourceScanner forResource() {
        return ResourceScanner.INSTANCE;
    }

    public static abstract class ZipEntryMatcher
    implements IMatcher<ZipEntry> {
        @Override
        public boolean isDirEligible() {
            return false;
        }

        @Override
        public boolean isFileElegible() {
            return true;
        }

        @Override
        public abstract IMatcher.Direction matches(ZipEntry var1, String var2);
    }

    public static enum ResourceScanner {
        INSTANCE;


        private String decode(String url) {
            try {
                return URLDecoder.decode(url, "utf-8");
            }
            catch (UnsupportedEncodingException e) {
                return URLDecoder.decode(url);
            }
        }

        public List<URL> scan(String resourceBase, ResourceMatcher matcher) throws IOException {
            Enumeration<URL> resources = ((Object)((Object)this)).getClass().getClassLoader().getResources(resourceBase);
            ArrayList<URL> urls = new ArrayList<URL>();
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                this.scan(urls, url, matcher);
            }
            return urls;
        }

        private void scan(final List<URL> urls, final URL url, final ResourceMatcher matcher) throws IOException {
            String protocol = url.getProtocol();
            if ("file".equals(protocol)) {
                DirScanner.INSTANCE.scan(new File(this.decode(url.getPath())), new FileMatcher(){

                    @Override
                    public IMatcher.Direction matches(File base, String path) {
                        try {
                            URL u = new URL(url, path);
                            IMatcher.Direction d = matcher.matches(u, path);
                            if (d.isMatched()) {
                                urls.add(u);
                            }
                            return d;
                        }
                        catch (MalformedURLException malformedURLException) {
                            return IMatcher.Direction.DOWN;
                        }
                    }
                });
            } else if ("jar".equals(protocol)) {
                List<String> parts = Splitters.by('!').split(url.toExternalForm());
                int len = parts.size();
                String prefix = parts.remove(len - 1).substring(1);
                JarInputStream jis = null;
                for (int i = 0; i < len - 1; ++i) {
                    JarEntry e;
                    String nextPart;
                    String part = parts.get(i);
                    String string = nextPart = i + 1 < len - 1 ? parts.get(i + 1).substring(1) : null;
                    if (i == 0) {
                        URL top = new URL(part + "!/");
                        JarURLConnection conn = (JarURLConnection)top.openConnection();
                        JarFile jarFile = conn.getJarFile();
                        Enumeration<JarEntry> jarEntries = jarFile.entries();
                        while (jarEntries.hasMoreElements()) {
                            JarEntry jarEntry = jarEntries.nextElement();
                            String name = jarEntry.getName();
                            if (nextPart == null && name.startsWith(prefix)) {
                                String p = name.substring(prefix.length());
                                URL u = new URL(url, p);
                                IMatcher.Direction d = matcher.matches(u, p);
                                if (!d.isMatched()) continue;
                                urls.add(u);
                                continue;
                            }
                            if (!name.equals(nextPart)) continue;
                            int size = (int)jarEntry.getSize();
                            byte[] data = Files.forIO().readFrom(jarFile.getInputStream(jarEntry), size);
                            jis = new JarInputStream(new ByteArrayInputStream(data));
                            break;
                        }
                        jarFile.close();
                        continue;
                    }
                    if (jis == null) continue;
                    JarInputStream newJis = null;
                    while ((e = (JarEntry)jis.getNextEntry()) != null) {
                        if (e.isDirectory()) continue;
                        String name = e.getName();
                        if (nextPart == null && name.startsWith(prefix)) {
                            String p = name.substring(prefix.length());
                            URL u = new URL(url, p);
                            IMatcher.Direction d = matcher.matches(u, p);
                            if (!d.isMatched()) continue;
                            urls.add(u);
                            continue;
                        }
                        if (!name.equals(nextPart)) continue;
                        int size = (int)e.getSize();
                        byte[] data = new byte[size];
                        for (int off = 0; off < size; off += jis.read(data, off, size)) {
                        }
                        newJis = new JarInputStream(new ByteArrayInputStream(data));
                        break;
                    }
                    jis.close();
                    jis = newJis;
                }
            }
        }
    }

    public static abstract class ResourceMatcher
    implements IMatcher<URL> {
        @Override
        public boolean isDirEligible() {
            return false;
        }

        @Override
        public boolean isFileElegible() {
            return true;
        }

        @Override
        public abstract IMatcher.Direction matches(URL var1, String var2);
    }

    public static enum JarScanner {
        INSTANCE;


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ZipEntry getEntry(String jarFileName, String name) {
            ZipFile zipFile = null;
            try {
                ZipEntry entry;
                zipFile = new ZipFile(jarFileName);
                ZipEntry zipEntry = entry = zipFile.getEntry(name);
                return zipEntry;
            }
            catch (IOException e1) {
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException e) {}
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] getEntryContent(String jarFileName, String entryPath) {
            byte[] bytes = null;
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(jarFileName);
                ZipEntry entry = zipFile.getEntry(entryPath);
                if (entry != null) {
                    InputStream inputStream = zipFile.getInputStream(entry);
                    bytes = Files.forIO().readFrom(inputStream);
                }
            }
            catch (Exception e) {
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (Exception e) {}
                }
            }
            return bytes;
        }

        public boolean hasEntry(String jarFileName, String name) {
            return this.getEntry(jarFileName, name) != null;
        }

        public List<String> scan(File base, IMatcher<File> matcher) {
            ArrayList<String> files = new ArrayList<String>();
            this.scanForFiles(base, matcher, false, files);
            return files;
        }

        public List<String> scan(ZipFile zipFile, IMatcher<ZipEntry> matcher) {
            ArrayList<String> files = new ArrayList<String>();
            this.scanForEntries(zipFile, matcher, false, files);
            return files;
        }

        private void scanForEntries(ZipFile zipFile, IMatcher<ZipEntry> matcher, boolean foundFirst, List<String> names) {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                IMatcher.Direction direction;
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (matcher.isDirEligible() && entry.isDirectory()) {
                    direction = matcher.matches(entry, name);
                    if (direction.isMatched()) {
                        names.add(name);
                    }
                } else if (matcher.isFileElegible() && !entry.isDirectory() && (direction = matcher.matches(entry, name)).isMatched()) {
                    names.add(name);
                }
                if (!foundFirst || names.size() <= 0) continue;
                break;
            }
        }

        private void scanForFiles(File jarFile, IMatcher<File> matcher, boolean foundFirst, List<String> names) {
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(jarFile);
            }
            catch (IOException e) {
                // empty catch block
            }
            if (zipFile != null) {
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    IMatcher.Direction direction;
                    ZipEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (matcher.isDirEligible() && entry.isDirectory()) {
                        direction = matcher.matches(jarFile, name);
                        if (direction.isMatched()) {
                            names.add(name);
                        }
                    } else if (matcher.isFileElegible() && !entry.isDirectory() && (direction = matcher.matches(jarFile, name)).isMatched()) {
                        names.add(name);
                    }
                    if (!foundFirst || names.size() <= 0) continue;
                    break;
                }
            }
        }

        public String scanForOne(File jarFile, IMatcher<File> matcher) {
            ArrayList<String> files = new ArrayList<String>(1);
            this.scanForFiles(jarFile, matcher, true, files);
            if (files.isEmpty()) {
                return null;
            }
            return (String)files.get(0);
        }
    }

    public static interface IMatcher<T> {
        public boolean isDirEligible();

        public boolean isFileElegible();

        public Direction matches(T var1, String var2);

        public static enum Direction {
            MATCHED,
            DOWN,
            NEXT;


            public boolean isDown() {
                return this == DOWN;
            }

            public boolean isMatched() {
                return this == MATCHED;
            }

            public boolean isNext() {
                return this == NEXT;
            }
        }
    }

    public static abstract class FileMatcher
    implements IMatcher<File> {
        @Override
        public boolean isDirEligible() {
            return false;
        }

        @Override
        public boolean isFileElegible() {
            return true;
        }
    }

    public static enum DirScanner {
        INSTANCE;


        public List<File> scan(File base, IMatcher<File> matcher) {
            ArrayList<File> files = new ArrayList<File>();
            StringBuilder relativePath = new StringBuilder();
            this.scanForFiles(base, relativePath, matcher, false, files);
            return files;
        }

        private void scanForFiles(File base, StringBuilder relativePath, IMatcher<File> matcher, boolean foundFirst, List<File> files) {
            int len = relativePath.length();
            File dir = len == 0 ? base : new File(base, relativePath.toString());
            String[] list = dir.list();
            if (list != null) {
                for (String item : list) {
                    IMatcher.Direction direction;
                    File child = new File(dir, item);
                    if (len > 0) {
                        relativePath.append('/');
                    }
                    relativePath.append(item);
                    if (matcher.isDirEligible() && child.isDirectory()) {
                        direction = matcher.matches(base, relativePath.toString());
                        switch (direction) {
                            case MATCHED: {
                                files.add(child);
                                break;
                            }
                            case DOWN: {
                                this.scanForFiles(base, relativePath, matcher, foundFirst, files);
                                break;
                            }
                        }
                    } else if (matcher.isFileElegible()) {
                        direction = matcher.matches(base, relativePath.toString());
                        switch (direction) {
                            case MATCHED: {
                                if (!child.isFile()) break;
                                files.add(child);
                                break;
                            }
                            case DOWN: {
                                if (!child.isDirectory()) break;
                                this.scanForFiles(base, relativePath, matcher, foundFirst, files);
                                break;
                            }
                        }
                    }
                    relativePath.setLength(len);
                    if (foundFirst && files.size() > 0) break;
                }
            }
        }

        public File scanForOne(File base, IMatcher<File> matcher) {
            ArrayList<File> files = new ArrayList<File>(1);
            StringBuilder relativePath = new StringBuilder();
            this.scanForFiles(base, relativePath, matcher, true, files);
            if (files.isEmpty()) {
                return null;
            }
            return (File)files.get(0);
        }
    }

    public static abstract class DirMatcher
    implements IMatcher<File> {
        @Override
        public boolean isDirEligible() {
            return true;
        }

        @Override
        public boolean isFileElegible() {
            return false;
        }
    }
}

