/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.logging;

import java.util.HashMap;
import java.util.Map;
import org.unidal.lookup.logging.AbstractLogger;
import org.unidal.lookup.logging.Logger;
import org.unidal.lookup.logging.LoggerManager;

public abstract class AbstractLoggerManager
implements LoggerManager {
    private Map<String, Logger> m_loggers = new HashMap<String, Logger>();
    private int m_threshold = 1;

    protected abstract AbstractLogger createLogger(String var1);

    @Override
    public Logger getLoggerForComponent(String role) {
        Logger logger = this.m_loggers.get(role);
        if (logger == null) {
            logger = this.createLogger(role);
            this.m_loggers.put(role, logger);
        }
        return logger;
    }

    protected int getThreshold() {
        return this.m_threshold;
    }

    protected boolean isValidThreshold(int threshold) {
        if (threshold == 0) {
            return true;
        }
        if (threshold == 1) {
            return true;
        }
        if (threshold == 2) {
            return true;
        }
        if (threshold == 3) {
            return true;
        }
        return threshold == 4;
    }

    public void setThreshold(int threshold) {
        if (this.isValidThreshold(threshold)) {
            this.m_threshold = threshold;
            for (Logger logger : this.m_loggers.values()) {
                logger.setThreshold(threshold);
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

