/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.lookup.logging;

import java.util.HashSet;
import java.util.Set;
import org.unidal.lookup.annotation.Named;
import org.unidal.lookup.logging.AbstractLogger;
import org.unidal.lookup.logging.AbstractLoggerManager;
import org.unidal.lookup.logging.LoggerManager;
import org.unidal.lookup.logging.TimedConsoleLogger;

@Named(type=LoggerManager.class)
public class TimedConsoleLoggerManager
extends AbstractLoggerManager {
    private static Set<String> s_skipedClassNames = new HashSet<String>();
    private String m_dateFormat = "MM-dd HH:mm:ss.SSS";
    private String m_logFilePattern;
    private String m_baseDirRef;
    private boolean m_showClass = true;
    private boolean m_devMode;
    private String m_defaultBaseDir;
    private int m_threshold = 1;
    private AbstractLogger m_logger;

    public static boolean shouldSkipClass(String className) {
        return s_skipedClassNames.contains(className);
    }

    public static void skipClass(Class<?> clazz) {
        s_skipedClassNames.add(clazz.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AbstractLogger createLogger(String name) {
        if (this.m_logger == null) {
            TimedConsoleLoggerManager timedConsoleLoggerManager = this;
            synchronized (timedConsoleLoggerManager) {
                if (this.m_logger == null) {
                    TimedConsoleLogger logger = new TimedConsoleLogger(this.m_threshold, name, this.m_dateFormat, this.m_logFilePattern, this.m_showClass, this.m_devMode);
                    logger.setBaseDirRef(this.m_baseDirRef);
                    logger.setDefaultBaseDir(this.m_defaultBaseDir);
                    this.m_logger = logger;
                }
            }
        }
        return this.m_logger;
    }

    public void setBaseDirRef(String baseDirRef) {
        this.m_baseDirRef = baseDirRef;
    }

    public void setDateFormat(String dateFormat) {
        this.m_dateFormat = dateFormat;
    }

    public void setDefaultBaseDir(String defaultBaseDir) {
        this.m_defaultBaseDir = defaultBaseDir;
    }

    public void setDevMode(boolean devMode) {
        this.m_devMode = devMode;
    }

    public void setLogFilePattern(String logFilePattern) {
        this.m_logFilePattern = logFilePattern;
    }

    public void setShowClass(boolean showClass) {
        this.m_showClass = showClass;
    }
}

