package com.reyun.controller.manage;

import com.reyun.dic.LogEnumType;
import com.reyun.model.Account;
import com.reyun.model.IntelligentPath;
import com.reyun.security.annotation.CurrentAccount;
import com.reyun.service.IntelligentPathService;
import com.reyun.service.UserLogService;
import com.reyun.util.ResultModel;
import com.reyun.util.ResultStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.*;

/**
 * Created by sunhao on 17/7/18.
 * desc:智能路径controller
 */
@Controller
@RequestMapping("/mng/intelligentpath")
public class MngIntelligentPathController {

    @Autowired
    IntelligentPathService intelligentPathService;

    @Autowired
    UserLogService userLogService;


    @RequestMapping(value = "create", method = RequestMethod.POST)
    @ResponseBody
    public ResultModel createIntelligentPathQuery(@CurrentAccount Account loginAccount, @RequestBody IntelligentPath intelligentPath) {

        //名字校验
        if (!intelligentPathService.checkIntelligentPathName(loginAccount.getId(), null, intelligentPath.getApp(), intelligentPath.getName())) {
            return ResultModel.ERROR(ResultStatus.NAME_EXIST);
        }

        //参数校验
        if (StringUtils.isEmpty(intelligentPath.getName()) || null == intelligentPath.getApp() || StringUtils.isEmpty(intelligentPath.getEvents())
                || StringUtils.isEmpty(intelligentPath.getTargetEvent()) || StringUtils.isEmpty(intelligentPath.getEventCondition())
                || null == intelligentPath.getStartOrEnd() || null == intelligentPath.getSession()) {

            return ResultModel.ERROR(ResultStatus.PARAM_INVALID);
        }

        userLogService.insertLog(loginAccount, LogEnumType.CREATE.getCode(), LogEnumType.CREATE.getName() + "智能路径", intelligentPath);

        return ResultModel.OK(intelligentPathService.createIntelligentPath(loginAccount, intelligentPath));
    }

    @RequestMapping(value = "{appId}/list", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel getQueryList(@CurrentAccount Account loginAccount, @PathVariable Long appId) {
        return ResultModel.OK(intelligentPathService.listIntelligentPath(loginAccount, appId));
    }

    @RequestMapping(value = "update", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel updateIntelligentPathQuery(@CurrentAccount Account loginAccount, @RequestBody IntelligentPath source) {

        //名字校验
        if (!intelligentPathService.checkIntelligentPathName(loginAccount.getId(), source.getId(), source.getApp(), source.getName())) {
            return ResultModel.ERROR(ResultStatus.NAME_EXIST);
        }

        userLogService.insertLog(loginAccount, LogEnumType.UPDATE.getCode(), LogEnumType.UPDATE.getName() + "智能路径", source);

        return ResultModel.OK(intelligentPathService.updateIntelligentPath(loginAccount, source));
    }

    @RequestMapping(value = "{pathId}/delete", method = RequestMethod.DELETE)
    @ResponseBody
    public ResultModel deleteIntelligentPathQuery(@CurrentAccount Account loginAccount, @PathVariable Long pathId) {

        userLogService.insertLog(loginAccount, LogEnumType.DELETE.getCode(), LogEnumType.DELETE.getName() + "智能路径", pathId);

        return ResultModel.OK(intelligentPathService.deleteIntelligentPath(loginAccount, pathId));
    }

}
