package com.reyun.model;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import java.util.Date;

/**
 * Created by song on 2017/9/28.
 */

/**
 * 字段说明：
 * id：属性id
 * attributeName：属性名字
 * appKey：appId
 * isAllRestrict：是否所有的用户都进行了限制appId
 * isRootRestrict:本app所属的母账户下的所有app是否都进行了限制
 * isParentRestrict:创建此app的账户所创建的所有的app是否都进行了限制
 * isAppRestrict：本app是否进行了限制
 * type:属性类型，是事件属性还是用户属性
 * isEventRestrict：此种类的属性是否进行了限制
 * isProfileRestrict：此种类的属性是否进行了限制
 * createTime：创建时间
 * modifyTime：修改时间
 *
 *
 * 插入数据说明：
 * 1.表中的每一条记录是某一条属性针对某一个app建立的限制条件；
 * 2.要限制所有的用户不能使用这个属性分组，那么需要在表中单独插入一条记录，属性名字定义为attributeName,appKey为all，如果所有用户都不能
 * 使用本条属性进行分组，那么就把isAllRestrict字段置为true，否则的话置为false，
 * 3.如果要对某一个用户下的所有的app的某个属性进行限制，那么需要把这个账户下所有的app查出来，每一个app存一条记录，将isRootRestrict
 * 字段置为true；
 * 4.如果要对某一个子账户创建的app进行限制，那么就把这个子账户下的所有的app都查出来，每一个app存一条记录，将isParentRestrict字段置为true；
 * 5.如果要对某一个app进行限制，那么就将这个app存一条记录，将isAppRestrict字段置为true;
 * 6.type字段要区分是事件属性还是用户属性，因为用户属性和事件属性的名字可能相同，因此属性的类型不能为null;
 *
 * 查询数据说明：
 * 1.在查询这个表的时候，应该先查询属性名为attributeName，appKey为all的记录，查询isAllRestrict这个字段的值，
 * 如果没有限制，就查询本app所对应的记录，只要isRootRestrict、isParentRestrict、isAppRestrict或者这几个
 * 字段有一个字段为true，那么就说明对本属性进行了限制；
 */

@Entity
public class AttributeRestrict {
    @Id
    @GeneratedValue
    private Long id;
    private String attributeName;
    private String appKey;
    private boolean isAllRestrict=false;
    private boolean isRootRestrict=false;
    private boolean isParentRestrict=false;
    private boolean isAppRestrict=false;
    private String type;
    private boolean isEventRestrict=false;
    private boolean isProfileRestrict=false;
    private Date createTime=new Date();
    private Date modifyTime;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAttributeName() {
        return attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getAppKey() {
        return appKey;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public boolean isAllRestrict() {
        return isAllRestrict;
    }

    public void setAllRestrict(boolean allRestrict) {
        isAllRestrict = allRestrict;
    }

    public boolean isRootRestrict() {
        return isRootRestrict;
    }

    public void setRootRestrict(boolean rootRestrict) {
        isRootRestrict = rootRestrict;
    }

    public boolean isParentRestrict() {
        return isParentRestrict;
    }

    public void setParentRestrict(boolean parentRestrict) {
        isParentRestrict = parentRestrict;
    }

    public boolean isAppRestrict() {
        return isAppRestrict;
    }

    public void setAppRestrict(boolean appRestrict) {
        isAppRestrict = appRestrict;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean isEventRestrict() {
        return isEventRestrict;
    }

    public void setEventRestrict(boolean eventRestrict) {
        isEventRestrict = eventRestrict;
    }

    public boolean isProfileRestrict() {
        return isProfileRestrict;
    }

    public void setProfileRestrict(boolean profileRestrict) {
        isProfileRestrict = profileRestrict;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }
}
