package com.reyun.model;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.validation.constraints.NotNull;

/**
 * Created by sunhao on 17/9/21.
 * 复杂事件操作符
 */
@Entity
public class ComplicatedParam {

    private Long id;

    //属性名
    private String viewAttr;

    //属性中文名称
    private String viewAttrName;

    //属性类型 avg sum
    private String attrType;

    //属性级别 1,2
    private Integer attrLevel;

    //有效性
    private Boolean valid;

    // view出现在哪个类型前面
    private String viewType;

    public ComplicatedParam(){}

    public ComplicatedParam(String viewAttr, String viewAttrName) {
        this.viewAttr = viewAttr;
        this.viewAttrName = viewAttrName;
    }

    @Id
    @GeneratedValue
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getViewAttr() {
        return viewAttr;
    }

    public void setViewAttr(String viewAttr) {
        this.viewAttr = viewAttr;
    }

    public String getViewAttrName() {
        return viewAttrName;
    }

    public void setViewAttrName(String viewAttrName) {
        this.viewAttrName = viewAttrName;
    }

    public String getAttrType() {
        return attrType;
    }

    public void setAttrType(String attrType) {
        this.attrType = attrType;
    }

    public Integer getAttrLevel() {
        return attrLevel;
    }

    public void setAttrLevel(Integer attrLevel) {
        this.attrLevel = attrLevel;
    }

    @NotNull
    public Boolean getValid() {
        return valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    public String getViewType() {
        return viewType;
    }

    public void setViewType(String viewType) {
        this.viewType = viewType;
    }
}
